dnl MRCP_CHECK_SWIFT

AC_DEFUN([MRCP_CHECK_SWIFT],
[  
    AC_MSG_NOTICE([Cepstral Swift library configuration])

    AC_MSG_CHECKING([for swift])
    AC_ARG_WITH(swift,
                [  --with-swift=PATH       prefix for installed Swift],
                [swift_path=$withval],
                [swift_path="/opt/swift"]
                )
    
    if test -d "$swift_path"; then
        found_swift="yes"
        MRCP_SWIFT_INCLUDES="-I$swift_path/include"
        MRCP_SWIFT_LIBS="-lswift -lceplex_us -lceplang_en -lm"
        MRCP_SWIFT_LDFLAGS="-L$swift_path/lib/ -R$swift_path/lib/"

        AC_SUBST(MRCP_SWIFT_INCLUDES)
        AC_SUBST(MRCP_SWIFT_LIBS)
        AC_SUBST(MRCP_SWIFT_LDFLAGS)
    else
	AC_MSG_WARN([not found])
    
    fi

    AM_CONDITIONAL(HAVE_SWIFT_SYNTHESIZER, test x"${found_swift}" == xyes)
    AC_MSG_RESULT($swift_path)
])
