/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "apt_log.h"

typedef struct apt_logger_t apt_logger_t;

struct apt_logger_t {
	apt_log_priority_t priority;
	apt_log_handler    handler;
};

static apt_logger_t apt_logger = {APT_PRIO_DEBUG, NULL};

APT_DECLARE(apt_bool_t) apt_log_initialize(apt_log_priority_t priority)
{
	apt_logger.priority = priority;
	apt_logger.handler = NULL;
	return TRUE;
}

APT_DECLARE(void) apt_log_priority_set(apt_log_priority_t priority)
{
	apt_logger.priority = priority;
}

APT_DECLARE(void) apt_log_handler_set(apt_log_handler handler)
{
	apt_logger.handler = handler;
}

APT_DECLARE(apt_bool_t) apt_log(apt_log_priority_t priority, const char *format, ...)
{
	apt_bool_t status = TRUE;
	if(priority <= apt_logger.priority) {
		va_list arg_ptr;
		va_start(arg_ptr, format);
		if(apt_logger.handler) {
			status = apt_logger.handler(priority,format,arg_ptr);
		}
		else {
			if(vprintf(format,arg_ptr) < 0) {
				status = FALSE;
			}
		}
		va_end(arg_ptr); 
	}
	return status;
}
