/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __APT_UNIQUE_ID_H__
#define __APT_UNIQUE_ID_H__

/**
 * @file aptlog.h
 * @brief Unique Identifier
 */ 

#include "apt.h"

APT_BEGIN_EXTERN_C

typedef struct apt_unique_id apt_unique_id;
/** Unambiguous string identifier. */
struct apt_unique_id {
	/* hex char array */
	const char *hex_str;
	/* if legnth == 0  strlen(hex_str) should be used */
	apr_size_t  length;
};

/**
 * Generate unique identifier (hex string)
 * @param id the id to be generated
 * @param length the length of hex string to be generated
 * @param pool the pool to allocate memory from
 */
APT_DECLARE(apt_bool_t) apt_unique_id_generate(apt_unique_id *id, apr_size_t length, apr_pool_t *pool);


APT_END_EXTERN_C

#endif /*__APT_UNIQUE_ID_H__*/
