/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_MEDIA_BASE_H__
#define __MRCP_MEDIA_BASE_H__

/**
 * @file mrcp_media_base.h
 * @brief MRCP Media Base (SDP m=)
 */ 

#include "mrcp_types.h"

MRCP_BEGIN_EXTERN_C

/** MRCP media state */
typedef enum {
	MRCP_MEDIA_DISABLED,
	MRCP_MEDIA_ENABLED
} mrcp_media_state_t;

typedef struct mrcp_media_base_t mrcp_media_base_t;
/** MRCP media base */
struct mrcp_media_base_t {
	int                type;
	mrcp_media_state_t state;

	const char        *ip;
	unsigned short     port;
	size_t             id;
};

/** Initialize MRCP media */
static APR_INLINE void mrcp_media_base_init(mrcp_media_base_t *media)
{
	media->type = 0;
	media->state = MRCP_MEDIA_DISABLED;
	media->ip = NULL;
	media->port = 0;
	media->id = 0;
}

MRCP_END_EXTERN_C

#endif /*__MRCP_MEDIA_BASE_H__*/
