/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "mrcp_client_signaling_agent.h"
#include "mrcp_client_defs.h"

mrcp_signaling_agent_t* mrcp_client_signaling_agent_create(
					const mrcp_signaling_agent_method_set_t *agent_method_set,
					const mrcp_module_method_set_t *module_method_set,
					void *object,
					apr_pool_t *pool)
{
	mrcp_signaling_agent_t* agent = apr_palloc(pool,sizeof(mrcp_signaling_agent_t));
	agent->method_set = agent_method_set;
	agent->object = object;

	mrcp_module_init(&agent->module,module_method_set);

	agent->client_ip = NULL;
	agent->client_sip_port = 0;
	agent->server_ip = NULL;
	agent->server_sip_port = 0;
	agent->sip_contact_str = NULL;
	agent->sip_to_str = NULL;
	agent->sip_from_str = NULL;
	agent->resource_location = NULL;
	
	mrcp_descriptor_init(&agent->server_capabilities);

	return agent;
}

void* mrcp_client_signaling_agent_object_get(mrcp_signaling_agent_t *agent)
{
	return agent->object;
}


mrcp_signaling_channel_t* mrcp_client_signaling_channel_create(
									mrcp_signaling_agent_t *agent,
									const mrcp_signaling_channel_method_set_t *method_set,
									void *object,
									apr_pool_t *pool)
{
	mrcp_signaling_channel_t* channel = apr_palloc(pool,sizeof(mrcp_signaling_channel_t));
	channel->method_set = method_set;
	channel->object = object;

	channel->agent = agent;
	channel->session = NULL;
	channel->pool = pool;

	mrcp_descriptor_init(&channel->local_descriptor);
	mrcp_descriptor_init(&channel->remote_descriptor);

	channel->local_descriptor.ip = agent->client_ip;
	return channel;
}

void* mrcp_client_signaling_channel_object_get(mrcp_signaling_channel_t *channel)
{
	return channel->object;
}

mrcp_signaling_agent_t* mrcp_client_signaling_channel_agent_get(mrcp_signaling_channel_t *channel)
{
	return channel->agent;
}

mrcp_status_t mrcp_client_signaling_agent_signal(mrcp_signaling_agent_t *agent, apt_task_msg_t *task_msg)
{
	return agent->module.signal(&agent->module,task_msg);
}
