/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __APT_STRING_TABLE_H__
#define __APT_STRING_TABLE_H__

/**
 * @file apt_string_table.h
 * @brief Generic String Table
 */ 

#include "apt.h"

APT_BEGIN_EXTERN_C

typedef struct apt_string_table_item_t apt_string_table_item_t;
/** Definition of string table item. */
struct apt_string_table_item_t {
	/** String value associated with id */
	const char *value;
	/** Length of string value */
	apr_size_t  length;
	/** Index of the unique (key) character to compare */
	apr_size_t  key;
};

/** String table is array of string table items. */
typedef apt_string_table_item_t* apt_string_table_t;

/**
 * Get the string associated with a given id from the table.
 * @param table the table to search for the string
 * @param size the size of the table
 * @param id the id to search for
 * @return the string associated with the id, or NULL if the id is invalid
 */
APT_DECLARE(const char*) apt_string_table_get(const apt_string_table_item_t *table, apr_size_t size, apr_size_t id);

/**
 * Find the id associated with a given string from the table.
 * @param table the table to search for the id
 * @param size the size of the table
 * @param value the string to search for
 * @return the id associated with the string, or invalid id if string cannot be matched
 */
APT_DECLARE(apr_size_t) apt_string_table_find(const apt_string_table_item_t *table, apr_size_t size, const char *value);


APT_END_EXTERN_C

#endif /*__APT_STRING_TABLE__*/
