/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __OPENMRCP_SERVER_H__
#define __OPENMRCP_SERVER_H__

/**
 * @file openmrcp_client.h
 * @brief OpenMRCP Client (user level interface).
 */ 

#include <apr_network_io.h>
#include <apr_dso.h>
#include "mrcp_server.h"


MRCP_BEGIN_EXTERN_C

typedef struct openmrcp_server_options_t openmrcp_server_options_t;
/** OpenMRCP server configuration */
struct openmrcp_server_options_t {
	/* base object */
	mrcp_server_module_loader_t    module_loader;

	mrcp_version_t                 proto_version;

	char                          *local_ip;
	apr_port_t                     local_port;
	
	apr_port_t                     mrcp_port;

	apr_port_t                     rtp_port_min;
	apr_port_t                     rtp_port_max;

	apr_dso_handle_t              *synth_plugin;
	apr_dso_handle_t              *recog_plugin;

	char                          *resource_location;
	const apt_string_table_item_t *resource_string_table;
};

/** 
 * Create the default options for server.
 * @param pool the pool to allocate memory from
 * @return the created options instance
 */
openmrcp_server_options_t* openmrcp_server_options_create(apr_pool_t *pool);


/** 
 * Start MRCP server with predefined modules.
 * @param options the configuration of OpenMRCP server
 * @param client_context the context attached to client
 * @return the created client instance
 */
mrcp_server_t* openmrcp_server_start(openmrcp_server_options_t *options);

/** 
 * Shutdown MRCP server.
 * @param mrcp_server the MRCP server to shutdown
 */
mrcp_status_t openmrcp_server_shutdown(mrcp_server_t *mrcp_server);


MRCP_END_EXTERN_C

#endif /*__OPENMRCP_SERVER_H__*/
