/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_RECOGNIZER_CHANNEL_H__
#define __MRCP_RECOGNIZER_CHANNEL_H__

/**
 * @file mrcp_recognizer_channel.h
 * @brief MRCP Recognizer Channel Definition
 */ 

#include "mrcp_server_resource.h"

MRCP_BEGIN_EXTERN_C

/** MRCP recognizer channel states */
typedef enum {
	RECOGNIZER_STATE_IDLE,
	RECOGNIZER_STATE_RECOGNIZING,
	RECOGNIZER_STATE_RECOGNIZED
} mrcp_recognizer_state_t;

/** Create MRCP recognizer server resource */
mrcp_resource_t* mrcp_recognizer_server_resource_create(mrcp_version_t version, apr_pool_t *pool);

MRCP_END_EXTERN_C

#endif /*__MRCP_RECOGNIZER_CHANNEL_H__*/
