/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "apt_string_table.h"
#include "mrcp_media_control.h"

/* string table of mrcp proto types (mrcp_proto_type) */
static const apt_string_table_item_t mrcp_proto_type_table[] = {
	{"TCP/MRCPv2",    10,4},
	{"TCP/TLS/MRCPv2",14,4}
};

/* string table of mrcp media attributes (mrcp_sdp_attribute_id) */
static const apt_string_table_item_t mrcp_control_attrib_table[] = {
	{"setup",      5,0},
	{"connection",10,1},
	{"resource",   8,0},
	{"channel",    7,1},
	{"cmid",       4,1}
};

/* string table of mrcp setup attribute values (mrcp_control_setup_type) */
static const apt_string_table_item_t mrcp_control_setup_value_table[] = {
	{"active",      6,0},
	{"passive",     7,0}
};

/* string table of mrcp connection attribute values (mrcp_control_connection_type) */
static const apt_string_table_item_t mrcp_control_connection_value_table[] = {
	{"new",         3,0},
	{"existing",    8,0}
};


const char* mrcp_proto_get(mrcp_proto_type proto)
{
	return apt_string_table_get(mrcp_proto_type_table,MRCP_PROTO_COUNT,proto);
}

mrcp_proto_type mrcp_proto_find(const char *attrib)
{
	return apt_string_table_find(mrcp_proto_type_table,MRCP_PROTO_COUNT,attrib);
}


const char* mrcp_control_attrib_str_get(mrcp_control_attrib_id attrib_id)
{
	return apt_string_table_get(mrcp_control_attrib_table,MRCP_CONTROL_ATTRIB_COUNT,attrib_id);
}

mrcp_control_attrib_id mrcp_control_attrib_id_find(const char *attrib)
{
	return apt_string_table_find(mrcp_control_attrib_table,MRCP_CONTROL_ATTRIB_COUNT,attrib);
}


const char* mrcp_control_setup_type_get(mrcp_control_setup_type setup_type)
{
	return apt_string_table_get(mrcp_control_setup_value_table,MRCP_CONTROL_SETUP_TYPE_COUNT,setup_type);
}

mrcp_control_setup_type mrcp_control_setup_type_find(const char *attrib)
{
	return apt_string_table_find(mrcp_control_setup_value_table,MRCP_CONTROL_SETUP_TYPE_COUNT,attrib);
}


const char* mrcp_control_connection_type_get(mrcp_control_connection_type connection_type)
{
	return apt_string_table_get(mrcp_control_connection_value_table,MRCP_CONTROL_CONNECTION_TYPE_COUNT,connection_type);
}

mrcp_control_connection_type mrcp_control_connection_type_find(const char *attrib)
{
	return apt_string_table_find(mrcp_control_connection_value_table,MRCP_CONTROL_CONNECTION_TYPE_COUNT,attrib);
}
