/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_MEDIA_AUDIO_H__
#define __MRCP_MEDIA_AUDIO_H__

/**
 * @file mrcp_media_audio.h
 * @brief MRCP Audio Media (SDP m=audio)
 */ 

#include "mrcp_media_base.h"
#include "codec_descriptor.h"

MRCP_BEGIN_EXTERN_C

/** MRCP audio attributes */
typedef enum {
	MRCP_AUDIO_ATTRIB_RTPMAP,
	MRCP_AUDIO_ATTRIB_SENDONLY,
	MRCP_AUDIO_ATTRIB_RECVONLY,
	MRCP_AUDIO_ATTRIB_SENDRECV,
	MRCP_AUDIO_ATTRIB_MID,
	MRCP_AUDIO_ATTRIB_PTIME,

	MRCP_AUDIO_ATTRIB_COUNT,
	MRCP_AUDIO_ATTRIB_UNKNOWN = MRCP_AUDIO_ATTRIB_COUNT
}mrcp_audio_attrib_id;

/** MRCP audio direction */
typedef enum {
	MRCP_AUDIO_NONE     = 0x0,
	MRCP_AUDIO_SEND     = 0x1,
	MRCP_AUDIO_RECEIVE  = 0x2,
	MRCP_AUDIO_DUPLEX   = MRCP_AUDIO_SEND | MRCP_AUDIO_RECEIVE
} mrcp_audio_direction_t;

#define MRCP_MAX_CODEC_COUNT 10

typedef struct mrcp_media_audio_t mrcp_media_audio_t;
/** MRCP audio media */
struct mrcp_media_audio_t {
	mrcp_media_base_t      base;
	
	mrcp_audio_direction_t direction;
	size_t                 mid;

	unsigned short         ptime;
	codec_descriptor_t    *codec_list[MRCP_MAX_CODEC_COUNT];
	size_t                 codec_count;
};

/** Initialize MRCP audio media */
static APR_INLINE void mrcp_media_audio_init(mrcp_media_audio_t *media)
{
	mrcp_media_base_init(&media->base);
	media->direction = MRCP_AUDIO_NONE;
	media->mid = 0;
	media->ptime = 0;
	media->codec_count = 0;
}

/** Get audio media attribute name by attribute identifier */
const char* mrcp_audio_attrib_str_get(mrcp_audio_attrib_id attrib_id);

/** Find audio media attribute identifier by attribute name */
mrcp_audio_attrib_id mrcp_audio_attrib_id_find(const char *attrib);

/** Get audio direction string by audio direction identifier */
const char* mrcp_audio_direction_str_get(mrcp_audio_direction_t direction);

MRCP_END_EXTERN_C

#endif /*__MRCP_MEDIA_AUDIO_H__*/
