/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_H__
#define __MRCP_H__

/**
 * @file mrcp.h
 * @brief MRCP Platform Definitions
 */ 

#include "apt.h"
#include "apt_log.h"

/* extern "C" defines */
#ifdef __cplusplus
#define MRCP_BEGIN_EXTERN_C       extern "C" {
#define MRCP_END_EXTERN_C         }
#else
#define MRCP_BEGIN_EXTERN_C
#define MRCP_END_EXTERN_C
#endif 

/* lib export/import defines (win32) */
#ifdef _WIN32
#ifdef MRCP_STATIC_LIB
#define MRCP_DECLARE
#else 
#ifdef MRCP_LIB_EXPORT
#define MRCP_DECLARE __declspec(dllexport)
#else
#define MRCP_DECLARE __declspec(dllimport)
#endif
#endif
#else
#define MRCP_DECLARE
#endif


MRCP_BEGIN_EXTERN_C

/** Generic status codes. */
typedef apt_bool_t mrcp_status_t;

#define MRCP_STATUS_SUCCESS TRUE
#define	MRCP_STATUS_FAILURE FALSE


MRCP_END_EXTERN_C

#endif /*__MRCP_H__*/
