/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_CLIENT_H__
#define __MRCP_CLIENT_H__

/**
 * @file mrcp_client.h
 * @brief MRCP Client Engine Definition.
 */ 

#include "mrcp_client_types.h"

MRCP_BEGIN_EXTERN_C

/** Module loader of MRCP client */
struct mrcp_client_module_loader_t {
	/** Create signaling agent */
	mrcp_signaling_agent_t* (*signaling_agent_create)(mrcp_client_module_loader_t *module_loader, apr_pool_t *pool);
	/** Create proto agent */
	mrcp_proto_agent_t* (*proto_agent_create)(mrcp_client_module_loader_t *module_loader, mrcp_signaling_agent_t *signaling_agent, apr_pool_t *pool);
	/** Create media agent */
	mrcp_media_agent_t* (*media_agent_create)(mrcp_client_module_loader_t *module_loader, apr_pool_t *pool);
	/** Create resources */
	mrcp_resource_container_t* (*resource_container_create)(mrcp_client_module_loader_t *module_loader, apr_pool_t *pool);
};

/** 
 * Create MRCP client instance and start message processing loop.
 * @param module_loader the module loader passed to created client instance
 * @return the created client instance
 */
mrcp_client_t* mrcp_client_start(mrcp_client_module_loader_t *module_loader, mrcp_client_context_t *client_context);
/** 
 * Shutdown message processing loop and destroy MRCP client.
 * @param mrcp_client the MRCP client to shutdown
 */
mrcp_status_t mrcp_client_shutdown(mrcp_client_t* mrcp_client);

MRCP_END_EXTERN_C

#endif /*__MRCP_CLIENT_H__*/
