/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __CODEC_DESCRIPTOR_H__
#define __CODEC_DESCRIPTOR_H__

/**
 * @file codec_descriptor.h
 * @brief Codec Descriptor Definition
 */ 

#include <apr.h>

#ifdef __cplusplus
extern "C" {
#endif


#define CODEC_FRAME_TIME_BASE 10 /*ms*/

typedef struct codec_descriptor_t codec_descriptor_t;
/** Codec descriptor */
struct codec_descriptor_t {
	apr_byte_t   payload_type;
	const char  *name;
	apr_uint16_t sampling_rate;
	apr_byte_t   channel_count;
	const char  *format;
};

typedef struct codec_frame_t codec_frame_t;
/** Codec frame */
struct codec_frame_t {
	void      *buffer;
	apr_size_t size;
};


/** Initialize codec descriptor */
static APR_INLINE void codec_descriptor_init(codec_descriptor_t *codec_descriptor)
{
	codec_descriptor->payload_type = 0;
	codec_descriptor->name = NULL;
	codec_descriptor->sampling_rate = 0;
	codec_descriptor->channel_count = 0;
	codec_descriptor->format = NULL;
}


#ifdef __cplusplus
}
#endif

#endif /*__CODEC_DESCRIPTOR_H__*/
