/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __AUDIO_BUFFER_H__
#define __AUDIO_BUFFER_H__

/**
 * @file audio_buffer.h
 * @brief Cyclic Audio Buffer
 */ 

#include <apr_pools.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Opaque audio buffer declaration */
typedef struct audio_buffer_t audio_buffer_t;

/** Create audio buffer */
audio_buffer_t* audio_buffer_create(apr_size_t size, apr_pool_t *pool);

/** Destroy audio buffer */
apr_status_t audio_buffer_destroy(audio_buffer_t *buffer);

/** Open audio buffer */
apr_status_t audio_buffer_open(audio_buffer_t *buffer);

/** Close audio buffer */
apr_status_t audio_buffer_close(audio_buffer_t *buffer);

/** Pause audio buffer */
apr_status_t audio_buffer_pause(audio_buffer_t *buffer);

/** Resume audio buffer */
apr_status_t audio_buffer_resume(audio_buffer_t *buffer);

/** Read data from audio buffer */
apr_status_t audio_buffer_read(audio_buffer_t *buffer, void *data, apr_size_t size);

/** Write data to audio buffer */
apr_status_t audio_buffer_write(audio_buffer_t *buffer, void *data, apr_size_t size);

/** Wait for read to complete */
apr_status_t audio_buffer_wait_for_read_complete(audio_buffer_t *buffer);

#ifdef __cplusplus
}
#endif

#endif /*__AUDIO_BUFFER_H__*/
