/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace FreeSWITCH.Native {

using System;
using System.Runtime.InteropServices;

class freeswitchPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("mod_mono", EntryPoint="SWIGRegisterExceptionCallbacks_freeswitch")]
    public static extern void SWIGRegisterExceptionCallbacks_freeswitch(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("mod_mono", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_freeswitch")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_freeswitch(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_freeswitch(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_freeswitch(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(freeswitchPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(freeswitchPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("mod_mono", EntryPoint="SWIGRegisterStringCallback_freeswitch")]
    public static extern void SWIGRegisterStringCallback_freeswitch(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_freeswitch(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  [DllImport("mod_mono", EntryPoint="CSharp_FREESWITCH_PEN_get")]
  public static extern string FREESWITCH_PEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_FREESWITCH_OID_PREFIX_get")]
  public static extern string FREESWITCH_OID_PREFIX_get();

  [DllImport("mod_mono", EntryPoint="CSharp_FREESWITCH_ITAD_get")]
  public static extern string FREESWITCH_ITAD_get();

  [DllImport("mod_mono", EntryPoint="CSharp___EXTENSIONS___get")]
  public static extern int __EXTENSIONS___get();

  [DllImport("mod_mono", EntryPoint="CSharp___BSD_VISIBLE_get")]
  public static extern int __BSD_VISIBLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BLANK_STRING_get")]
  public static extern string SWITCH_BLANK_STRING_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_ESC_get")]
  public static extern string SWITCH_SEQ_ESC_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_HOME_CHAR_get")]
  public static extern char SWITCH_SEQ_HOME_CHAR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_HOME_CHAR_STR_get")]
  public static extern string SWITCH_SEQ_HOME_CHAR_STR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARLINE_CHAR_get")]
  public static extern char SWITCH_SEQ_CLEARLINE_CHAR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARLINE_CHAR_STR_get")]
  public static extern string SWITCH_SEQ_CLEARLINE_CHAR_STR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARLINEEND_CHAR_get")]
  public static extern string SWITCH_SEQ_CLEARLINEEND_CHAR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARSCR_CHAR0_get")]
  public static extern char SWITCH_SEQ_CLEARSCR_CHAR0_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARSCR_CHAR1_get")]
  public static extern char SWITCH_SEQ_CLEARSCR_CHAR1_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARSCR_CHAR_get")]
  public static extern string SWITCH_SEQ_CLEARSCR_CHAR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_AND_COLOR_get")]
  public static extern string SWITCH_SEQ_AND_COLOR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_END_COLOR_get")]
  public static extern string SWITCH_SEQ_END_COLOR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_BLACK_get")]
  public static extern string SWITCH_SEQ_F_BLACK_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_RED_get")]
  public static extern string SWITCH_SEQ_F_RED_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_GREEN_get")]
  public static extern string SWITCH_SEQ_F_GREEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_YELLOW_get")]
  public static extern string SWITCH_SEQ_F_YELLOW_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_BLUE_get")]
  public static extern string SWITCH_SEQ_F_BLUE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_MAGEN_get")]
  public static extern string SWITCH_SEQ_F_MAGEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_CYAN_get")]
  public static extern string SWITCH_SEQ_F_CYAN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_F_WHITE_get")]
  public static extern string SWITCH_SEQ_F_WHITE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_BLACK_get")]
  public static extern string SWITCH_SEQ_B_BLACK_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_RED_get")]
  public static extern string SWITCH_SEQ_B_RED_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_GREEN_get")]
  public static extern string SWITCH_SEQ_B_GREEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_YELLOW_get")]
  public static extern string SWITCH_SEQ_B_YELLOW_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_BLUE_get")]
  public static extern string SWITCH_SEQ_B_BLUE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_MAGEN_get")]
  public static extern string SWITCH_SEQ_B_MAGEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_CYAN_get")]
  public static extern string SWITCH_SEQ_B_CYAN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_B_WHITE_get")]
  public static extern string SWITCH_SEQ_B_WHITE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FBLACK_get")]
  public static extern string SWITCH_SEQ_FBLACK_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FRED_get")]
  public static extern string SWITCH_SEQ_FRED_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FGREEN_get")]
  public static extern string SWITCH_SEQ_FGREEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FYELLOW_get")]
  public static extern string SWITCH_SEQ_FYELLOW_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FBLUE_get")]
  public static extern string SWITCH_SEQ_FBLUE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FMAGEN_get")]
  public static extern string SWITCH_SEQ_FMAGEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FCYAN_get")]
  public static extern string SWITCH_SEQ_FCYAN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_FWHITE_get")]
  public static extern string SWITCH_SEQ_FWHITE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BBLACK_get")]
  public static extern string SWITCH_SEQ_BBLACK_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BRED_get")]
  public static extern string SWITCH_SEQ_BRED_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BGREEN_get")]
  public static extern string SWITCH_SEQ_BGREEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BYELLOW_get")]
  public static extern string SWITCH_SEQ_BYELLOW_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BBLUE_get")]
  public static extern string SWITCH_SEQ_BBLUE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BMAGEN_get")]
  public static extern string SWITCH_SEQ_BMAGEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BCYAN_get")]
  public static extern string SWITCH_SEQ_BCYAN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_BWHITE_get")]
  public static extern string SWITCH_SEQ_BWHITE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_HOME_get")]
  public static extern string SWITCH_SEQ_HOME_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARLINE_get")]
  public static extern string SWITCH_SEQ_CLEARLINE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARLINEEND_get")]
  public static extern string SWITCH_SEQ_CLEARLINEEND_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SEQ_CLEARSCR_get")]
  public static extern string SWITCH_SEQ_CLEARSCR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_DEFAULT_DTMF_DURATION_get")]
  public static extern int SWITCH_DEFAULT_DTMF_DURATION_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_DTMF_DURATION_get")]
  public static extern int SWITCH_MAX_DTMF_DURATION_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_PATH_SEPARATOR_get")]
  public static extern string SWITCH_PATH_SEPARATOR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_URL_SEPARATOR_get")]
  public static extern string SWITCH_URL_SEPARATOR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_PROTO_SPECIFIC_HANGUP_CAUSE_VARIABLE_get")]
  public static extern string SWITCH_PROTO_SPECIFIC_HANGUP_CAUSE_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CHANNEL_EXECUTE_ON_ANSWER_VARIABLE_get")]
  public static extern string SWITCH_CHANNEL_EXECUTE_ON_ANSWER_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CALL_TIMEOUT_VARIABLE_get")]
  public static extern string SWITCH_CALL_TIMEOUT_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_HOLDING_UUID_VARIABLE_get")]
  public static extern string SWITCH_HOLDING_UUID_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_API_BRIDGE_END_VARIABLE_get")]
  public static extern string SWITCH_API_BRIDGE_END_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_API_HANGUP_HOOK_VARIABLE_get")]
  public static extern string SWITCH_API_HANGUP_HOOK_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_PROCESS_CDR_VARIABLE_get")]
  public static extern string SWITCH_PROCESS_CDR_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BRIDGE_CHANNEL_VARIABLE_get")]
  public static extern string SWITCH_BRIDGE_CHANNEL_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CHANNEL_NAME_VARIABLE_get")]
  public static extern string SWITCH_CHANNEL_NAME_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BRIDGE_UUID_VARIABLE_get")]
  public static extern string SWITCH_BRIDGE_UUID_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_PLAYBACK_TERMINATORS_VARIABLE_get")]
  public static extern string SWITCH_PLAYBACK_TERMINATORS_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CACHE_SPEECH_HANDLES_VARIABLE_get")]
  public static extern string SWITCH_CACHE_SPEECH_HANDLES_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CACHE_SPEECH_HANDLES_OBJ_NAME_get")]
  public static extern string SWITCH_CACHE_SPEECH_HANDLES_OBJ_NAME_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BYPASS_MEDIA_VARIABLE_get")]
  public static extern string SWITCH_BYPASS_MEDIA_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_PROXY_MEDIA_VARIABLE_get")]
  public static extern string SWITCH_PROXY_MEDIA_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_ENDPOINT_DISPOSITION_VARIABLE_get")]
  public static extern string SWITCH_ENDPOINT_DISPOSITION_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_HOLD_MUSIC_VARIABLE_get")]
  public static extern string SWITCH_HOLD_MUSIC_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_EXPORT_VARS_VARIABLE_get")]
  public static extern string SWITCH_EXPORT_VARS_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_R_SDP_VARIABLE_get")]
  public static extern string SWITCH_R_SDP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_L_SDP_VARIABLE_get")]
  public static extern string SWITCH_L_SDP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_B_SDP_VARIABLE_get")]
  public static extern string SWITCH_B_SDP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BRIDGE_VARIABLE_get")]
  public static extern string SWITCH_BRIDGE_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SIGNAL_BRIDGE_VARIABLE_get")]
  public static extern string SWITCH_SIGNAL_BRIDGE_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SIGNAL_BOND_VARIABLE_get")]
  public static extern string SWITCH_SIGNAL_BOND_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_ORIGINATOR_VARIABLE_get")]
  public static extern string SWITCH_ORIGINATOR_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_ORIGINATOR_CODEC_VARIABLE_get")]
  public static extern string SWITCH_ORIGINATOR_CODEC_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_LOCAL_MEDIA_IP_VARIABLE_get")]
  public static extern string SWITCH_LOCAL_MEDIA_IP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_LOCAL_MEDIA_PORT_VARIABLE_get")]
  public static extern string SWITCH_LOCAL_MEDIA_PORT_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_REMOTE_MEDIA_IP_VARIABLE_get")]
  public static extern string SWITCH_REMOTE_MEDIA_IP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_REMOTE_MEDIA_PORT_VARIABLE_get")]
  public static extern string SWITCH_REMOTE_MEDIA_PORT_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_REMOTE_VIDEO_IP_VARIABLE_get")]
  public static extern string SWITCH_REMOTE_VIDEO_IP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_REMOTE_VIDEO_PORT_VARIABLE_get")]
  public static extern string SWITCH_REMOTE_VIDEO_PORT_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_LOCAL_VIDEO_IP_VARIABLE_get")]
  public static extern string SWITCH_LOCAL_VIDEO_IP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_LOCAL_VIDEO_PORT_VARIABLE_get")]
  public static extern string SWITCH_LOCAL_VIDEO_PORT_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_HANGUP_AFTER_BRIDGE_VARIABLE_get")]
  public static extern string SWITCH_HANGUP_AFTER_BRIDGE_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_EXEC_AFTER_BRIDGE_APP_VARIABLE_get")]
  public static extern string SWITCH_EXEC_AFTER_BRIDGE_APP_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_EXEC_AFTER_BRIDGE_ARG_VARIABLE_get")]
  public static extern string SWITCH_EXEC_AFTER_BRIDGE_ARG_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_FORWARDS_VARIABLE_get")]
  public static extern string SWITCH_MAX_FORWARDS_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_DISABLE_APP_LOG_VARIABLE_get")]
  public static extern string SWITCH_DISABLE_APP_LOG_VARIABLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SPEECH_KEY_get")]
  public static extern string SWITCH_SPEECH_KEY_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_UUID_BRIDGE_get")]
  public static extern string SWITCH_UUID_BRIDGE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BITS_PER_BYTE_get")]
  public static extern int SWITCH_BITS_PER_BYTE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dtmf_t_digit_set")]
  public static extern void switch_dtmf_t_digit_set(HandleRef jarg1, char jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dtmf_t_digit_get")]
  public static extern char switch_dtmf_t_digit_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dtmf_t_duration_set")]
  public static extern void switch_dtmf_t_duration_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dtmf_t_duration_get")]
  public static extern uint switch_dtmf_t_duration_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_dtmf_t")]
  public static extern IntPtr new_switch_dtmf_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_dtmf_t")]
  public static extern void delete_switch_dtmf_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_buf_set")]
  public static extern void switch_bitpack_t_buf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_buf_get")]
  public static extern IntPtr switch_bitpack_t_buf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_buflen_set")]
  public static extern void switch_bitpack_t_buflen_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_buflen_get")]
  public static extern uint switch_bitpack_t_buflen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_cur_set")]
  public static extern void switch_bitpack_t_cur_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_cur_get")]
  public static extern IntPtr switch_bitpack_t_cur_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bytes_set")]
  public static extern void switch_bitpack_t_bytes_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bytes_get")]
  public static extern uint switch_bitpack_t_bytes_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bits_tot_set")]
  public static extern void switch_bitpack_t_bits_tot_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bits_tot_get")]
  public static extern uint switch_bitpack_t_bits_tot_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bits_cur_set")]
  public static extern void switch_bitpack_t_bits_cur_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bits_cur_get")]
  public static extern byte switch_bitpack_t_bits_cur_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bits_rem_set")]
  public static extern void switch_bitpack_t_bits_rem_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_bits_rem_get")]
  public static extern byte switch_bitpack_t_bits_rem_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_frame_bits_set")]
  public static extern void switch_bitpack_t_frame_bits_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_frame_bits_get")]
  public static extern byte switch_bitpack_t_frame_bits_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_shiftby_set")]
  public static extern void switch_bitpack_t_shiftby_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_shiftby_get")]
  public static extern byte switch_bitpack_t_shiftby_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_this_byte_set")]
  public static extern void switch_bitpack_t_this_byte_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_this_byte_get")]
  public static extern byte switch_bitpack_t_this_byte_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_under_set")]
  public static extern void switch_bitpack_t_under_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_under_get")]
  public static extern byte switch_bitpack_t_under_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_over_set")]
  public static extern void switch_bitpack_t_over_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_over_get")]
  public static extern byte switch_bitpack_t_over_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_mode_set")]
  public static extern void switch_bitpack_t_mode_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_bitpack_t_mode_get")]
  public static extern int switch_bitpack_t_mode_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_bitpack_t")]
  public static extern IntPtr new_switch_bitpack_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_bitpack_t")]
  public static extern void delete_switch_bitpack_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_base_dir_set")]
  public static extern void switch_directories_base_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_base_dir_get")]
  public static extern string switch_directories_base_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_mod_dir_set")]
  public static extern void switch_directories_mod_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_mod_dir_get")]
  public static extern string switch_directories_mod_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_conf_dir_set")]
  public static extern void switch_directories_conf_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_conf_dir_get")]
  public static extern string switch_directories_conf_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_log_dir_set")]
  public static extern void switch_directories_log_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_log_dir_get")]
  public static extern string switch_directories_log_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_db_dir_set")]
  public static extern void switch_directories_db_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_db_dir_get")]
  public static extern string switch_directories_db_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_script_dir_set")]
  public static extern void switch_directories_script_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_script_dir_get")]
  public static extern string switch_directories_script_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_temp_dir_set")]
  public static extern void switch_directories_temp_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_temp_dir_get")]
  public static extern string switch_directories_temp_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_htdocs_dir_set")]
  public static extern void switch_directories_htdocs_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_htdocs_dir_get")]
  public static extern string switch_directories_htdocs_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_grammar_dir_set")]
  public static extern void switch_directories_grammar_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_grammar_dir_get")]
  public static extern string switch_directories_grammar_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_storage_dir_set")]
  public static extern void switch_directories_storage_dir_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directories_storage_dir_get")]
  public static extern string switch_directories_storage_dir_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_directories")]
  public static extern IntPtr new_switch_directories();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_directories")]
  public static extern void delete_switch_directories(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_GLOBAL_dirs_set")]
  public static extern void SWITCH_GLOBAL_dirs_set(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_GLOBAL_dirs_get")]
  public static extern IntPtr SWITCH_GLOBAL_dirs_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_STACKS_get")]
  public static extern int SWITCH_MAX_STACKS_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_THREAD_STACKSIZE_get")]
  public static extern int SWITCH_THREAD_STACKSIZE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_INTERVAL_get")]
  public static extern int SWITCH_MAX_INTERVAL_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_INTERVAL_PAD_get")]
  public static extern int SWITCH_INTERVAL_PAD_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_SAMPLE_LEN_get")]
  public static extern int SWITCH_MAX_SAMPLE_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_BYTES_PER_SAMPLE_get")]
  public static extern int SWITCH_BYTES_PER_SAMPLE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RECOMMENDED_BUFFER_SIZE_get")]
  public static extern int SWITCH_RECOMMENDED_BUFFER_SIZE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_CODECS_get")]
  public static extern int SWITCH_MAX_CODECS_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_STATE_HANDLERS_get")]
  public static extern int SWITCH_MAX_STATE_HANDLERS_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_QUEUE_LEN_get")]
  public static extern int SWITCH_CORE_QUEUE_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_MANAGEMENT_BUFFER_LEN_get")]
  public static extern int SWITCH_MAX_MANAGEMENT_BUFFER_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RTP_CNG_PAYLOAD_get")]
  public static extern int SWITCH_RTP_CNG_PAYLOAD_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_version_set")]
  public static extern void switch_rtp_hdr_t_version_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_version_get")]
  public static extern uint switch_rtp_hdr_t_version_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_p_set")]
  public static extern void switch_rtp_hdr_t_p_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_p_get")]
  public static extern uint switch_rtp_hdr_t_p_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_x_set")]
  public static extern void switch_rtp_hdr_t_x_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_x_get")]
  public static extern uint switch_rtp_hdr_t_x_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_cc_set")]
  public static extern void switch_rtp_hdr_t_cc_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_cc_get")]
  public static extern uint switch_rtp_hdr_t_cc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_m_set")]
  public static extern void switch_rtp_hdr_t_m_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_m_get")]
  public static extern uint switch_rtp_hdr_t_m_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_pt_set")]
  public static extern void switch_rtp_hdr_t_pt_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_pt_get")]
  public static extern uint switch_rtp_hdr_t_pt_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_seq_set")]
  public static extern void switch_rtp_hdr_t_seq_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_seq_get")]
  public static extern uint switch_rtp_hdr_t_seq_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_ts_set")]
  public static extern void switch_rtp_hdr_t_ts_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_ts_get")]
  public static extern uint switch_rtp_hdr_t_ts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_ssrc_set")]
  public static extern void switch_rtp_hdr_t_ssrc_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_hdr_t_ssrc_get")]
  public static extern uint switch_rtp_hdr_t_ssrc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_rtp_hdr_t")]
  public static extern IntPtr new_switch_rtp_hdr_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_rtp_hdr_t")]
  public static extern void delete_switch_rtp_hdr_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_input_callback_set")]
  public static extern void switch_input_args_t_input_callback_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_input_callback_get")]
  public static extern IntPtr switch_input_args_t_input_callback_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_buf_set")]
  public static extern void switch_input_args_t_buf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_buf_get")]
  public static extern IntPtr switch_input_args_t_buf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_buflen_set")]
  public static extern void switch_input_args_t_buflen_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_buflen_get")]
  public static extern uint switch_input_args_t_buflen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_read_frame_callback_set")]
  public static extern void switch_input_args_t_read_frame_callback_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_read_frame_callback_get")]
  public static extern IntPtr switch_input_args_t_read_frame_callback_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_user_data_set")]
  public static extern void switch_input_args_t_user_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_input_args_t_user_data_get")]
  public static extern IntPtr switch_input_args_t_user_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_input_args_t")]
  public static extern IntPtr new_switch_input_args_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_input_args_t")]
  public static extern void delete_switch_input_args_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_API_VERSION_get")]
  public static extern int SWITCH_API_VERSION_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_switch_api_version_set")]
  public static extern void switch_loadable_module_function_table_t_switch_api_version_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_switch_api_version_get")]
  public static extern int switch_loadable_module_function_table_t_switch_api_version_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_load_set")]
  public static extern void switch_loadable_module_function_table_t_load_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_load_get")]
  public static extern IntPtr switch_loadable_module_function_table_t_load_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_shutdown_set")]
  public static extern void switch_loadable_module_function_table_t_shutdown_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_shutdown_get")]
  public static extern IntPtr switch_loadable_module_function_table_t_shutdown_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_runtime_set")]
  public static extern void switch_loadable_module_function_table_t_runtime_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_function_table_t_runtime_get")]
  public static extern IntPtr switch_loadable_module_function_table_t_runtime_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_loadable_module_function_table_t")]
  public static extern IntPtr new_switch_loadable_module_function_table_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_loadable_module_function_table_t")]
  public static extern void delete_switch_loadable_module_function_table_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_close")]
  public static extern int switch_core_db_close(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_open")]
  public static extern int switch_core_db_open(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_column_text")]
  public static extern IntPtr switch_core_db_column_text(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_column_name")]
  public static extern string switch_core_db_column_name(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_column_count")]
  public static extern int switch_core_db_column_count(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_errmsg")]
  public static extern string switch_core_db_errmsg(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_exec")]
  public static extern int switch_core_db_exec(HandleRef jarg1, string jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_finalize")]
  public static extern int switch_core_db_finalize(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_prepare")]
  public static extern int switch_core_db_prepare(HandleRef jarg1, string jarg2, int jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_step")]
  public static extern int switch_core_db_step(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_reset")]
  public static extern int switch_core_db_reset(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_bind_int")]
  public static extern int switch_core_db_bind_int(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_bind_int64")]
  public static extern int switch_core_db_bind_int64(HandleRef jarg1, int jarg2, long jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_bind_text")]
  public static extern int switch_core_db_bind_text(HandleRef jarg1, int jarg2, string jarg3, int jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_bind_double")]
  public static extern int switch_core_db_bind_double(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_last_insert_rowid")]
  public static extern long switch_core_db_last_insert_rowid(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_get_table")]
  public static extern int switch_core_db_get_table(HandleRef jarg1, string jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_free_table")]
  public static extern void switch_core_db_free_table(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_free")]
  public static extern void switch_core_db_free(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_changes")]
  public static extern int switch_core_db_changes(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_OK_get")]
  public static extern int SWITCH_CORE_DB_OK_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_ERROR_get")]
  public static extern int SWITCH_CORE_DB_ERROR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_INTERNAL_get")]
  public static extern int SWITCH_CORE_DB_INTERNAL_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_PERM_get")]
  public static extern int SWITCH_CORE_DB_PERM_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_ABORT_get")]
  public static extern int SWITCH_CORE_DB_ABORT_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_BUSY_get")]
  public static extern int SWITCH_CORE_DB_BUSY_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_LOCKED_get")]
  public static extern int SWITCH_CORE_DB_LOCKED_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_NOMEM_get")]
  public static extern int SWITCH_CORE_DB_NOMEM_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_READONLY_get")]
  public static extern int SWITCH_CORE_DB_READONLY_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_INTERRUPT_get")]
  public static extern int SWITCH_CORE_DB_INTERRUPT_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_IOERR_get")]
  public static extern int SWITCH_CORE_DB_IOERR_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_CORRUPT_get")]
  public static extern int SWITCH_CORE_DB_CORRUPT_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_NOTFOUND_get")]
  public static extern int SWITCH_CORE_DB_NOTFOUND_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_FULL_get")]
  public static extern int SWITCH_CORE_DB_FULL_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_CANTOPEN_get")]
  public static extern int SWITCH_CORE_DB_CANTOPEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_PROTOCOL_get")]
  public static extern int SWITCH_CORE_DB_PROTOCOL_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_EMPTY_get")]
  public static extern int SWITCH_CORE_DB_EMPTY_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_SCHEMA_get")]
  public static extern int SWITCH_CORE_DB_SCHEMA_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_TOOBIG_get")]
  public static extern int SWITCH_CORE_DB_TOOBIG_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_CONSTRAINT_get")]
  public static extern int SWITCH_CORE_DB_CONSTRAINT_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_MISMATCH_get")]
  public static extern int SWITCH_CORE_DB_MISMATCH_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_MISUSE_get")]
  public static extern int SWITCH_CORE_DB_MISUSE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_NOLFS_get")]
  public static extern int SWITCH_CORE_DB_NOLFS_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_AUTH_get")]
  public static extern int SWITCH_CORE_DB_AUTH_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_FORMAT_get")]
  public static extern int SWITCH_CORE_DB_FORMAT_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_RANGE_get")]
  public static extern int SWITCH_CORE_DB_RANGE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_NOTADB_get")]
  public static extern int SWITCH_CORE_DB_NOTADB_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_ROW_get")]
  public static extern int SWITCH_CORE_DB_ROW_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_DONE_get")]
  public static extern int SWITCH_CORE_DB_DONE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_mprintf")]
  public static extern string switch_mprintf(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_regex_compile")]
  public static extern IntPtr switch_regex_compile(string jarg1, int jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_regex_copy_substring")]
  public static extern int switch_regex_copy_substring(string jarg1, HandleRef jarg2, int jarg3, int jarg4, string jarg5, int jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_regex_free")]
  public static extern void switch_regex_free(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_regex_perform")]
  public static extern int switch_regex_perform(string jarg1, string jarg2, HandleRef jarg3, HandleRef jarg4, uint jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_perform_substitution")]
  public static extern void switch_perform_substitution(HandleRef jarg1, int jarg2, string jarg3, string jarg4, string jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_regex_match")]
  public static extern int switch_regex_match(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_CORE_THREAD_SESSION_OBJS_get")]
  public static extern int SWITCH_MAX_CORE_THREAD_SESSION_OBJS_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_MAX_STREAMS_get")]
  public static extern int SWITCH_MAX_STREAMS_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_mms_set")]
  public static extern void switch_core_time_duration_mms_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_mms_get")]
  public static extern uint switch_core_time_duration_mms_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_ms_set")]
  public static extern void switch_core_time_duration_ms_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_ms_get")]
  public static extern uint switch_core_time_duration_ms_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_sec_set")]
  public static extern void switch_core_time_duration_sec_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_sec_get")]
  public static extern uint switch_core_time_duration_sec_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_min_set")]
  public static extern void switch_core_time_duration_min_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_min_get")]
  public static extern uint switch_core_time_duration_min_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_hr_set")]
  public static extern void switch_core_time_duration_hr_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_hr_get")]
  public static extern uint switch_core_time_duration_hr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_day_set")]
  public static extern void switch_core_time_duration_day_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_day_get")]
  public static extern uint switch_core_time_duration_day_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_yr_set")]
  public static extern void switch_core_time_duration_yr_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_time_duration_yr_get")]
  public static extern uint switch_core_time_duration_yr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_core_time_duration")]
  public static extern IntPtr new_switch_core_time_duration();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_core_time_duration")]
  public static extern void delete_switch_core_time_duration(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_app_log_app_set")]
  public static extern void switch_app_log_app_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_app_log_app_get")]
  public static extern string switch_app_log_app_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_app_log_arg_set")]
  public static extern void switch_app_log_arg_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_app_log_arg_get")]
  public static extern string switch_app_log_arg_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_app_log_next_set")]
  public static extern void switch_app_log_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_app_log_next_get")]
  public static extern IntPtr switch_app_log_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_app_log")]
  public static extern IntPtr new_switch_app_log();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_app_log")]
  public static extern void delete_switch_app_log(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_from_set")]
  public static extern void switch_core_session_message_from_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_from_get")]
  public static extern string switch_core_session_message_from_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_message_id_set")]
  public static extern void switch_core_session_message_message_id_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_message_id_get")]
  public static extern int switch_core_session_message_message_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_numeric_arg_set")]
  public static extern void switch_core_session_message_numeric_arg_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_numeric_arg_get")]
  public static extern int switch_core_session_message_numeric_arg_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_arg_set")]
  public static extern void switch_core_session_message_string_arg_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_arg_get")]
  public static extern string switch_core_session_message_string_arg_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_arg_size_set")]
  public static extern void switch_core_session_message_string_arg_size_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_arg_size_get")]
  public static extern IntPtr switch_core_session_message_string_arg_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_arg_set")]
  public static extern void switch_core_session_message_pointer_arg_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_arg_get")]
  public static extern IntPtr switch_core_session_message_pointer_arg_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_arg_size_set")]
  public static extern void switch_core_session_message_pointer_arg_size_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_arg_size_get")]
  public static extern IntPtr switch_core_session_message_pointer_arg_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_numeric_reply_set")]
  public static extern void switch_core_session_message_numeric_reply_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_numeric_reply_get")]
  public static extern int switch_core_session_message_numeric_reply_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_reply_set")]
  public static extern void switch_core_session_message_string_reply_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_reply_get")]
  public static extern string switch_core_session_message_string_reply_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_reply_size_set")]
  public static extern void switch_core_session_message_string_reply_size_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_string_reply_size_get")]
  public static extern IntPtr switch_core_session_message_string_reply_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_reply_set")]
  public static extern void switch_core_session_message_pointer_reply_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_reply_get")]
  public static extern IntPtr switch_core_session_message_pointer_reply_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_reply_size_set")]
  public static extern void switch_core_session_message_pointer_reply_size_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_pointer_reply_size_get")]
  public static extern IntPtr switch_core_session_message_pointer_reply_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_flags_set")]
  public static extern void switch_core_session_message_flags_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_flags_get")]
  public static extern int switch_core_session_message_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_core_session_message")]
  public static extern IntPtr new_switch_core_session_message();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_core_session_message")]
  public static extern void delete_switch_core_session_message(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_running_set")]
  public static extern void switch_core_thread_session_running_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_running_get")]
  public static extern int switch_core_thread_session_running_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_mutex_set")]
  public static extern void switch_core_thread_session_mutex_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_mutex_get")]
  public static extern IntPtr switch_core_thread_session_mutex_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_objs_set")]
  public static extern void switch_core_thread_session_objs_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_objs_get")]
  public static extern IntPtr switch_core_thread_session_objs_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_input_callback_set")]
  public static extern void switch_core_thread_session_input_callback_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_input_callback_get")]
  public static extern IntPtr switch_core_thread_session_input_callback_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_pool_set")]
  public static extern void switch_core_thread_session_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_pool_get")]
  public static extern IntPtr switch_core_thread_session_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_core_thread_session")]
  public static extern IntPtr new_switch_core_thread_session();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_core_thread_session")]
  public static extern void delete_switch_core_thread_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_add")]
  public static extern int switch_core_media_bug_add(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_get_user_data")]
  public static extern IntPtr switch_core_media_bug_get_user_data(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_get_write_replace_frame")]
  public static extern IntPtr switch_core_media_bug_get_write_replace_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_set_write_replace_frame")]
  public static extern void switch_core_media_bug_set_write_replace_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_get_read_replace_frame")]
  public static extern IntPtr switch_core_media_bug_get_read_replace_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_get_session")]
  public static extern IntPtr switch_core_media_bug_get_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_test_flag")]
  public static extern uint switch_core_media_bug_test_flag(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_set_read_replace_frame")]
  public static extern void switch_core_media_bug_set_read_replace_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_remove")]
  public static extern int switch_core_media_bug_remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_close")]
  public static extern int switch_core_media_bug_close(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_remove_all")]
  public static extern int switch_core_media_bug_remove_all(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_media_bug_read")]
  public static extern int switch_core_media_bug_read(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_port_allocator_new")]
  public static extern int switch_core_port_allocator_new(ushort jarg1, ushort jarg2, int jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_port_allocator_request_port")]
  public static extern int switch_core_port_allocator_request_port(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_port_allocator_free_port")]
  public static extern int switch_core_port_allocator_free_port(HandleRef jarg1, ushort jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_port_allocator_destroy")]
  public static extern void switch_core_port_allocator_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_init")]
  public static extern int switch_core_init(int jarg1, int jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_init_and_modload")]
  public static extern int switch_core_init_and_modload(int jarg1, int jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_limit")]
  public static extern uint switch_core_session_limit(uint jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_sessions_per_second")]
  public static extern uint switch_core_sessions_per_second(uint jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_destroy")]
  public static extern int switch_core_destroy();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_signal_lock")]
  public static extern int switch_core_session_signal_lock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_signal_unlock")]
  public static extern int switch_core_session_signal_unlock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_read_lock")]
  public static extern int switch_core_session_read_lock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_write_lock")]
  public static extern void switch_core_session_write_lock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_rwunlock")]
  public static extern void switch_core_session_rwunlock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_add_state_handler")]
  public static extern int switch_core_add_state_handler(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_get_state_handler")]
  public static extern IntPtr switch_core_get_state_handler(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_memory_pool_tag")]
  public static extern void switch_core_memory_pool_tag(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_new_memory_pool")]
  public static extern int switch_core_perform_new_memory_pool(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_destroy_memory_pool")]
  public static extern int switch_core_perform_destroy_memory_pool(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_run")]
  public static extern void switch_core_session_run(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_running")]
  public static extern uint switch_core_session_running(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_permanent_alloc")]
  public static extern IntPtr switch_core_perform_permanent_alloc(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_alloc")]
  public static extern IntPtr switch_core_perform_alloc(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_session_alloc")]
  public static extern IntPtr switch_core_perform_session_alloc(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_permanent_strdup")]
  public static extern string switch_core_perform_permanent_strdup(string jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_session_strdup")]
  public static extern string switch_core_perform_session_strdup(HandleRef jarg1, string jarg2, string jarg3, string jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_strdup")]
  public static extern string switch_core_perform_strdup(HandleRef jarg1, string jarg2, string jarg3, string jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_sprintf")]
  public static extern string switch_core_session_sprintf(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_sprintf")]
  public static extern string switch_core_sprintf(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_pool")]
  public static extern IntPtr switch_core_session_get_pool(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_request")]
  public static extern IntPtr switch_core_session_request(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_perform_destroy")]
  public static extern void switch_core_session_perform_destroy(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_count")]
  public static extern uint switch_core_session_count();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_id")]
  public static extern IntPtr switch_core_session_id();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_request_by_name")]
  public static extern IntPtr switch_core_session_request_by_name(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_thread_launch")]
  public static extern int switch_core_session_thread_launch(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_channel")]
  public static extern IntPtr switch_core_session_get_channel(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_signal_state_change")]
  public static extern void switch_core_session_signal_state_change(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_uuid")]
  public static extern string switch_core_session_get_uuid(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_get_uuid")]
  public static extern string switch_core_get_uuid();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_locate")]
  public static extern IntPtr switch_core_session_locate(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_get_variable")]
  public static extern string switch_core_get_variable(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_set_variable")]
  public static extern void switch_core_set_variable(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_hupall")]
  public static extern void switch_core_session_hupall(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_message_send")]
  public static extern int switch_core_session_message_send(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_queue_message")]
  public static extern int switch_core_session_queue_message(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_pass_indication")]
  public static extern int switch_core_session_pass_indication(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_queue_indication")]
  public static extern int switch_core_session_queue_indication(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_dequeue_message")]
  public static extern int switch_core_session_dequeue_message(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_flush_message")]
  public static extern int switch_core_session_flush_message(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_event_send")]
  public static extern int switch_core_session_event_send(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_app_log")]
  public static extern IntPtr switch_core_session_get_app_log(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_exec")]
  public static extern int switch_core_session_exec(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_execute_application")]
  public static extern int switch_core_session_execute_application(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_execute_exten")]
  public static extern int switch_core_session_execute_exten(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_receive_event")]
  public static extern int switch_core_session_receive_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_private")]
  public static extern IntPtr switch_core_session_get_private(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_set_private")]
  public static extern int switch_core_session_set_private(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_add_stream")]
  public static extern int switch_core_session_add_stream(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_stream")]
  public static extern IntPtr switch_core_session_get_stream(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_stream_count")]
  public static extern int switch_core_session_get_stream_count(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_launch_thread")]
  public static extern void switch_core_session_launch_thread(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_thread_session_end")]
  public static extern void switch_core_thread_session_end(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_service_session")]
  public static extern void switch_core_service_session(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_outgoing_channel")]
  public static extern int switch_core_session_outgoing_channel(HandleRef jarg1, HandleRef jarg2, string jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, int jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_resurrect_channel")]
  public static extern int switch_core_session_resurrect_channel(string jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_receive_message")]
  public static extern int switch_core_session_receive_message(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_queue_event")]
  public static extern int switch_core_session_queue_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_event_count")]
  public static extern uint switch_core_session_event_count(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_dequeue_event")]
  public static extern int switch_core_session_dequeue_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_queue_private_event")]
  public static extern int switch_core_session_queue_private_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_private_event_count")]
  public static extern uint switch_core_session_private_event_count(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_dequeue_private_event")]
  public static extern int switch_core_session_dequeue_private_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_flush_private_events")]
  public static extern uint switch_core_session_flush_private_events(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_read_frame")]
  public static extern int switch_core_session_read_frame(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_read_video_frame")]
  public static extern int switch_core_session_read_video_frame(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_write_video_frame")]
  public static extern int switch_core_session_write_video_frame(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_reset")]
  public static extern void switch_core_session_reset(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_write_frame")]
  public static extern int switch_core_session_write_frame(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_perform_kill_channel")]
  public static extern int switch_core_session_perform_kill_channel(HandleRef jarg1, string jarg2, string jarg3, int jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_send_dtmf")]
  public static extern int switch_core_session_send_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_send_dtmf_string")]
  public static extern int switch_core_session_send_dtmf_string(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_recv_dtmf")]
  public static extern int switch_core_session_recv_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_init")]
  public static extern int switch_core_hash_init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_destroy")]
  public static extern int switch_core_hash_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_insert")]
  public static extern int switch_core_hash_insert(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_insert_locked")]
  public static extern int switch_core_hash_insert_locked(HandleRef jarg1, string jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_delete")]
  public static extern int switch_core_hash_delete(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_delete_locked")]
  public static extern int switch_core_hash_delete_locked(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_find")]
  public static extern IntPtr switch_core_hash_find(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_hash_find_locked")]
  public static extern IntPtr switch_core_hash_find_locked(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_hash_first")]
  public static extern IntPtr switch_hash_first(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_hash_next")]
  public static extern IntPtr switch_hash_next(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_hash_this")]
  public static extern void switch_hash_this(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_timer_init")]
  public static extern int switch_core_timer_init(HandleRef jarg1, string jarg2, int jarg3, int jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_timer_next")]
  public static extern int switch_core_timer_next(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_timer_step")]
  public static extern int switch_core_timer_step(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_timer_sync")]
  public static extern int switch_core_timer_sync(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_timer_check")]
  public static extern int switch_core_timer_check(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_timer_destroy")]
  public static extern int switch_core_timer_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_codec_init")]
  public static extern int switch_core_codec_init(HandleRef jarg1, string jarg2, string jarg3, uint jarg4, int jarg5, int jarg6, uint jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_codec_copy")]
  public static extern int switch_core_codec_copy(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_codec_encode")]
  public static extern int switch_core_codec_encode(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, uint jarg4, uint jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_codec_decode")]
  public static extern int switch_core_codec_decode(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, uint jarg4, uint jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_codec_destroy")]
  public static extern int switch_core_codec_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_set_read_codec")]
  public static extern int switch_core_session_set_read_codec(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_read_codec")]
  public static extern IntPtr switch_core_session_get_read_codec(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_set_write_codec")]
  public static extern int switch_core_session_set_write_codec(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_write_codec")]
  public static extern IntPtr switch_core_session_get_write_codec(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_set_video_read_codec")]
  public static extern int switch_core_session_set_video_read_codec(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_video_read_codec")]
  public static extern IntPtr switch_core_session_get_video_read_codec(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_set_video_write_codec")]
  public static extern int switch_core_session_set_video_write_codec(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_get_video_write_codec")]
  public static extern IntPtr switch_core_session_get_video_write_codec(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_open_file")]
  public static extern IntPtr switch_core_db_open_file(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_persistant_execute")]
  public static extern int switch_core_db_persistant_execute(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_db_test_reactive")]
  public static extern void switch_core_db_test_reactive(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CORE_DB_get")]
  public static extern string SWITCH_CORE_DB_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_perform_file_open")]
  public static extern int switch_core_perform_file_open(string jarg1, string jarg2, int jarg3, HandleRef jarg4, string jarg5, byte jarg6, uint jarg7, uint jarg8, HandleRef jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_file_read")]
  public static extern int switch_core_file_read(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_file_write")]
  public static extern int switch_core_file_write(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_file_seek")]
  public static extern int switch_core_file_seek(HandleRef jarg1, HandleRef jarg2, long jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_file_set_string")]
  public static extern int switch_core_file_set_string(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_file_get_string")]
  public static extern int switch_core_file_get_string(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_file_close")]
  public static extern int switch_core_file_close(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_open")]
  public static extern int switch_core_speech_open(HandleRef jarg1, string jarg2, string jarg3, uint jarg4, uint jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_feed_tts")]
  public static extern int switch_core_speech_feed_tts(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_flush_tts")]
  public static extern void switch_core_speech_flush_tts(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_text_param_tts")]
  public static extern void switch_core_speech_text_param_tts(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_numeric_param_tts")]
  public static extern void switch_core_speech_numeric_param_tts(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_float_param_tts")]
  public static extern void switch_core_speech_float_param_tts(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_read_tts")]
  public static extern int switch_core_speech_read_tts(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_speech_close")]
  public static extern int switch_core_speech_close(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_open")]
  public static extern int switch_core_asr_open(HandleRef jarg1, string jarg2, string jarg3, int jarg4, string jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_close")]
  public static extern int switch_core_asr_close(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_feed")]
  public static extern int switch_core_asr_feed(HandleRef jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_check_results")]
  public static extern int switch_core_asr_check_results(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_get_results")]
  public static extern int switch_core_asr_get_results(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_load_grammar")]
  public static extern int switch_core_asr_load_grammar(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_unload_grammar")]
  public static extern int switch_core_asr_unload_grammar(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_pause")]
  public static extern int switch_core_asr_pause(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_asr_resume")]
  public static extern int switch_core_asr_resume(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_directory_open")]
  public static extern int switch_core_directory_open(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_directory_query")]
  public static extern int switch_core_directory_query(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_directory_next")]
  public static extern int switch_core_directory_next(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_directory_next_pair")]
  public static extern int switch_core_directory_next_pair(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_directory_close")]
  public static extern int switch_core_directory_close(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_data_channel")]
  public static extern IntPtr switch_core_data_channel(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_ready")]
  public static extern int switch_core_ready();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_flags")]
  public static extern int switch_core_flags();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_management_exec")]
  public static extern int switch_core_management_exec(string jarg1, int jarg2, string jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_set_high_priority")]
  public static extern int set_high_priority();

  [DllImport("mod_mono", EntryPoint="CSharp_change_user_group")]
  public static extern int change_user_group(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_runtime_loop")]
  public static extern void switch_core_runtime_loop(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_set_console")]
  public static extern int switch_core_set_console(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_measure_time")]
  public static extern void switch_core_measure_time(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_uptime")]
  public static extern IntPtr switch_core_uptime();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_ctl")]
  public static extern int switch_core_session_ctl(int jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_get_console")]
  public static extern IntPtr switch_core_get_console();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_launch_thread")]
  public static extern void switch_core_launch_thread(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_set_globals")]
  public static extern void switch_core_set_globals();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_session_compare")]
  public static extern byte switch_core_session_compare(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_mime_index")]
  public static extern IntPtr switch_core_mime_index();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_mime_ext2type")]
  public static extern string switch_core_mime_ext2type(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_mime_add_type")]
  public static extern int switch_core_mime_add_type(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_create_module_interface")]
  public static extern IntPtr switch_loadable_module_create_module_interface(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_loadable_module_create_interface")]
  public static extern IntPtr switch_loadable_module_create_interface(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timestamp_now")]
  public static extern IntPtr switch_timestamp_now();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_memory_reclaim")]
  public static extern void switch_core_memory_reclaim();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_memory_reclaim_events")]
  public static extern void switch_core_memory_reclaim_events();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_memory_reclaim_logger")]
  public static extern void switch_core_memory_reclaim_logger();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_memory_reclaim_all")]
  public static extern void switch_core_memory_reclaim_all();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_setrlimits")]
  public static extern void switch_core_setrlimits();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_time_sync")]
  public static extern void switch_time_sync();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timestamp")]
  public static extern IntPtr switch_timestamp(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_load_network_lists")]
  public static extern void switch_load_network_lists(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_check_network_list_ip")]
  public static extern int switch_check_network_list_ip(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_time_set_monotonic")]
  public static extern void switch_time_set_monotonic(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_max_dtmf_duration")]
  public static extern uint switch_core_max_dtmf_duration(uint jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_default_dtmf_duration")]
  public static extern uint switch_core_default_dtmf_duration(uint jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_console_set_complete")]
  public static extern int switch_console_set_complete(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_console_set_alias")]
  public static extern int switch_console_set_alias(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_CMD_CHUNK_LEN_get")]
  public static extern int SWITCH_CMD_CHUNK_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_console_loop")]
  public static extern void switch_console_loop();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_console_stream_raw_write")]
  public static extern int switch_console_stream_raw_write(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SMAX_get")]
  public static extern int SWITCH_SMAX_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_SMIN_get")]
  public static extern int SWITCH_SMIN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_is_moh")]
  public static extern int switch_is_moh(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_b64_encode")]
  public static extern int switch_b64_encode(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_b64_decode")]
  public static extern IntPtr switch_b64_decode(string jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_amp_encode")]
  public static extern string switch_amp_encode(string jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_is_digit_string")]
  public static extern int switch_is_digit_string(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_fd_read_line")]
  public static extern IntPtr switch_fd_read_line(int jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_find_local_ip")]
  public static extern int switch_find_local_ip(string jarg1, int jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_get_addr")]
  public static extern string get_addr(string jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_priority_name")]
  public static extern string switch_priority_name(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rfc2833_to_char")]
  public static extern char switch_rfc2833_to_char(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_char_to_rfc2833")]
  public static extern byte switch_char_to_rfc2833(char jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_clean_string")]
  public static extern string switch_clean_string(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_strstr")]
  public static extern int switch_strstr(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_str_time")]
  public static extern IntPtr switch_str_time(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_separate_string")]
  public static extern uint switch_separate_string(string jarg1, char jarg2, HandleRef jarg3, uint jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_is_number")]
  public static extern int switch_is_number(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_strip_spaces")]
  public static extern string switch_strip_spaces(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_separate_paren_args")]
  public static extern string switch_separate_paren_args(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stristr")]
  public static extern string switch_stristr(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_is_lan_addr")]
  public static extern int switch_is_lan_addr(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_replace_char")]
  public static extern string switch_replace_char(string jarg1, char jarg2, char jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ast2regex")]
  public static extern int switch_ast2regex(string jarg1, string jarg2, uint jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_escape_char")]
  public static extern string switch_escape_char(HandleRef jarg1, string jarg2, string jarg3, char jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_socket_waitfor")]
  public static extern int switch_socket_waitfor(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_cut_path")]
  public static extern string switch_cut_path(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_string_replace")]
  public static extern string switch_string_replace(string jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_string_match")]
  public static extern int switch_string_match(string jarg1, uint jarg2, string jarg3, uint jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_url_encode")]
  public static extern uint switch_url_encode(string jarg1, string jarg2, uint jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_url_decode")]
  public static extern string switch_url_decode(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_simple_email")]
  public static extern int switch_simple_email(string jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_find_end_paren")]
  public static extern string switch_find_end_paren(string jarg1, char jarg2, char jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_parse_cidr")]
  public static extern int switch_parse_cidr(string jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_network_list_create")]
  public static extern int switch_network_list_create(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_network_list_add_cidr")]
  public static extern int switch_network_list_add_cidr(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_network_list_add_host_mask")]
  public static extern int switch_network_list_add_host_mask(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_network_list_validate_ip")]
  public static extern int switch_network_list_validate_ip(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_username_set")]
  public static extern void switch_caller_profile_username_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_username_get")]
  public static extern string switch_caller_profile_username_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_dialplan_set")]
  public static extern void switch_caller_profile_dialplan_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_dialplan_get")]
  public static extern string switch_caller_profile_dialplan_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_id_name_set")]
  public static extern void switch_caller_profile_caller_id_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_id_name_get")]
  public static extern string switch_caller_profile_caller_id_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_id_number_set")]
  public static extern void switch_caller_profile_caller_id_number_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_id_number_get")]
  public static extern string switch_caller_profile_caller_id_number_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_ton_set")]
  public static extern void switch_caller_profile_caller_ton_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_ton_get")]
  public static extern byte switch_caller_profile_caller_ton_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_numplan_set")]
  public static extern void switch_caller_profile_caller_numplan_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_numplan_get")]
  public static extern byte switch_caller_profile_caller_numplan_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_network_addr_set")]
  public static extern void switch_caller_profile_network_addr_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_network_addr_get")]
  public static extern string switch_caller_profile_network_addr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_ani_set")]
  public static extern void switch_caller_profile_ani_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_ani_get")]
  public static extern string switch_caller_profile_ani_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_ani_ton_set")]
  public static extern void switch_caller_profile_ani_ton_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_ani_ton_get")]
  public static extern byte switch_caller_profile_ani_ton_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_ani_numplan_set")]
  public static extern void switch_caller_profile_ani_numplan_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_ani_numplan_get")]
  public static extern byte switch_caller_profile_ani_numplan_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_aniii_set")]
  public static extern void switch_caller_profile_aniii_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_aniii_get")]
  public static extern string switch_caller_profile_aniii_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_rdnis_set")]
  public static extern void switch_caller_profile_rdnis_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_rdnis_get")]
  public static extern string switch_caller_profile_rdnis_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_rdnis_ton_set")]
  public static extern void switch_caller_profile_rdnis_ton_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_rdnis_ton_get")]
  public static extern byte switch_caller_profile_rdnis_ton_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_rdnis_numplan_set")]
  public static extern void switch_caller_profile_rdnis_numplan_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_rdnis_numplan_get")]
  public static extern byte switch_caller_profile_rdnis_numplan_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_destination_number_set")]
  public static extern void switch_caller_profile_destination_number_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_destination_number_get")]
  public static extern string switch_caller_profile_destination_number_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_destination_number_ton_set")]
  public static extern void switch_caller_profile_destination_number_ton_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_destination_number_ton_get")]
  public static extern byte switch_caller_profile_destination_number_ton_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_destination_number_numplan_set")]
  public static extern void switch_caller_profile_destination_number_numplan_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_destination_number_numplan_get")]
  public static extern byte switch_caller_profile_destination_number_numplan_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_source_set")]
  public static extern void switch_caller_profile_source_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_source_get")]
  public static extern string switch_caller_profile_source_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_chan_name_set")]
  public static extern void switch_caller_profile_chan_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_chan_name_get")]
  public static extern string switch_caller_profile_chan_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_uuid_set")]
  public static extern void switch_caller_profile_uuid_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_uuid_get")]
  public static extern string switch_caller_profile_uuid_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_context_set")]
  public static extern void switch_caller_profile_context_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_context_get")]
  public static extern string switch_caller_profile_context_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_profile_index_set")]
  public static extern void switch_caller_profile_profile_index_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_profile_index_get")]
  public static extern string switch_caller_profile_profile_index_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_flags_set")]
  public static extern void switch_caller_profile_flags_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_flags_get")]
  public static extern int switch_caller_profile_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_originator_caller_profile_set")]
  public static extern void switch_caller_profile_originator_caller_profile_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_originator_caller_profile_get")]
  public static extern IntPtr switch_caller_profile_originator_caller_profile_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_originatee_caller_profile_set")]
  public static extern void switch_caller_profile_originatee_caller_profile_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_originatee_caller_profile_get")]
  public static extern IntPtr switch_caller_profile_originatee_caller_profile_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_times_set")]
  public static extern void switch_caller_profile_times_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_times_get")]
  public static extern IntPtr switch_caller_profile_times_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_extension_set")]
  public static extern void switch_caller_profile_caller_extension_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_caller_extension_get")]
  public static extern IntPtr switch_caller_profile_caller_extension_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_pool_set")]
  public static extern void switch_caller_profile_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_pool_get")]
  public static extern IntPtr switch_caller_profile_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_next_set")]
  public static extern void switch_caller_profile_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_next_get")]
  public static extern IntPtr switch_caller_profile_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_caller_profile")]
  public static extern IntPtr new_switch_caller_profile();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_caller_profile")]
  public static extern void delete_switch_caller_profile(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_application_name_set")]
  public static extern void switch_caller_application_application_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_application_name_get")]
  public static extern string switch_caller_application_application_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_application_data_set")]
  public static extern void switch_caller_application_application_data_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_application_data_get")]
  public static extern string switch_caller_application_application_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_application_function_set")]
  public static extern void switch_caller_application_application_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_application_function_get")]
  public static extern IntPtr switch_caller_application_application_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_next_set")]
  public static extern void switch_caller_application_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_application_next_get")]
  public static extern IntPtr switch_caller_application_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_caller_application")]
  public static extern IntPtr new_switch_caller_application();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_caller_application")]
  public static extern void delete_switch_caller_application(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_extension_name_set")]
  public static extern void switch_caller_extension_extension_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_extension_name_get")]
  public static extern string switch_caller_extension_extension_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_extension_number_set")]
  public static extern void switch_caller_extension_extension_number_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_extension_number_get")]
  public static extern string switch_caller_extension_extension_number_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_current_application_set")]
  public static extern void switch_caller_extension_current_application_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_current_application_get")]
  public static extern IntPtr switch_caller_extension_current_application_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_last_application_set")]
  public static extern void switch_caller_extension_last_application_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_last_application_get")]
  public static extern IntPtr switch_caller_extension_last_application_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_applications_set")]
  public static extern void switch_caller_extension_applications_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_applications_get")]
  public static extern IntPtr switch_caller_extension_applications_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_children_set")]
  public static extern void switch_caller_extension_children_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_children_get")]
  public static extern IntPtr switch_caller_extension_children_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_next_set")]
  public static extern void switch_caller_extension_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_next_get")]
  public static extern IntPtr switch_caller_extension_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_caller_extension")]
  public static extern IntPtr new_switch_caller_extension();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_caller_extension")]
  public static extern void delete_switch_caller_extension(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_new")]
  public static extern IntPtr switch_caller_extension_new(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_extension_add_application")]
  public static extern void switch_caller_extension_add_application(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_get_field_by_name")]
  public static extern string switch_caller_get_field_by_name(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_new")]
  public static extern IntPtr switch_caller_profile_new(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5, string jarg6, string jarg7, string jarg8, string jarg9, string jarg10, string jarg11, string jarg12);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_clone")]
  public static extern IntPtr switch_caller_profile_clone(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_dup")]
  public static extern IntPtr switch_caller_profile_dup(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_caller_profile_event_set_data")]
  public static extern void switch_caller_profile_event_set_data(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_codec_set")]
  public static extern void switch_frame_codec_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_codec_get")]
  public static extern IntPtr switch_frame_codec_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_source_set")]
  public static extern void switch_frame_source_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_source_get")]
  public static extern string switch_frame_source_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_packet_set")]
  public static extern void switch_frame_packet_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_packet_get")]
  public static extern IntPtr switch_frame_packet_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_packetlen_set")]
  public static extern void switch_frame_packetlen_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_packetlen_get")]
  public static extern uint switch_frame_packetlen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_data_set")]
  public static extern void switch_frame_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_data_get")]
  public static extern IntPtr switch_frame_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_datalen_set")]
  public static extern void switch_frame_datalen_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_datalen_get")]
  public static extern uint switch_frame_datalen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_buflen_set")]
  public static extern void switch_frame_buflen_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_buflen_get")]
  public static extern uint switch_frame_buflen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_samples_set")]
  public static extern void switch_frame_samples_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_samples_get")]
  public static extern uint switch_frame_samples_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_rate_set")]
  public static extern void switch_frame_rate_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_rate_get")]
  public static extern uint switch_frame_rate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_payload_set")]
  public static extern void switch_frame_payload_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_payload_get")]
  public static extern byte switch_frame_payload_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_timestamp_set")]
  public static extern void switch_frame_timestamp_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_timestamp_get")]
  public static extern IntPtr switch_frame_timestamp_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_seq_set")]
  public static extern void switch_frame_seq_set(HandleRef jarg1, ushort jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_seq_get")]
  public static extern ushort switch_frame_seq_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_ssrc_set")]
  public static extern void switch_frame_ssrc_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_ssrc_get")]
  public static extern uint switch_frame_ssrc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_m_set")]
  public static extern void switch_frame_m_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_m_get")]
  public static extern int switch_frame_m_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_flags_set")]
  public static extern void switch_frame_flags_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_frame_flags_get")]
  public static extern int switch_frame_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_frame")]
  public static extern IntPtr new_switch_frame();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_frame")]
  public static extern void delete_switch_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_init_set")]
  public static extern void switch_state_handler_table_on_init_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_init_get")]
  public static extern IntPtr switch_state_handler_table_on_init_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_routing_set")]
  public static extern void switch_state_handler_table_on_routing_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_routing_get")]
  public static extern IntPtr switch_state_handler_table_on_routing_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_execute_set")]
  public static extern void switch_state_handler_table_on_execute_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_execute_get")]
  public static extern IntPtr switch_state_handler_table_on_execute_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_hangup_set")]
  public static extern void switch_state_handler_table_on_hangup_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_hangup_get")]
  public static extern IntPtr switch_state_handler_table_on_hangup_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_exchange_media_set")]
  public static extern void switch_state_handler_table_on_exchange_media_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_exchange_media_get")]
  public static extern IntPtr switch_state_handler_table_on_exchange_media_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_soft_execute_set")]
  public static extern void switch_state_handler_table_on_soft_execute_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_soft_execute_get")]
  public static extern IntPtr switch_state_handler_table_on_soft_execute_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_consume_media_set")]
  public static extern void switch_state_handler_table_on_consume_media_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_consume_media_get")]
  public static extern IntPtr switch_state_handler_table_on_consume_media_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_hibernate_set")]
  public static extern void switch_state_handler_table_on_hibernate_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_hibernate_get")]
  public static extern IntPtr switch_state_handler_table_on_hibernate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_reset_set")]
  public static extern void switch_state_handler_table_on_reset_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_reset_get")]
  public static extern IntPtr switch_state_handler_table_on_reset_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_park_set")]
  public static extern void switch_state_handler_table_on_park_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_on_park_get")]
  public static extern IntPtr switch_state_handler_table_on_park_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_padding_set")]
  public static extern void switch_state_handler_table_padding_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_state_handler_table_padding_get")]
  public static extern IntPtr switch_state_handler_table_padding_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_state_handler_table")]
  public static extern IntPtr new_switch_state_handler_table();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_state_handler_table")]
  public static extern void delete_switch_state_handler_table(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_write_function_set")]
  public static extern void switch_stream_handle_write_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_write_function_get")]
  public static extern IntPtr switch_stream_handle_write_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_raw_write_function_set")]
  public static extern void switch_stream_handle_raw_write_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_raw_write_function_get")]
  public static extern IntPtr switch_stream_handle_raw_write_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_data_set")]
  public static extern void switch_stream_handle_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_data_get")]
  public static extern IntPtr switch_stream_handle_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_end_set")]
  public static extern void switch_stream_handle_end_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_end_get")]
  public static extern IntPtr switch_stream_handle_end_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_data_size_set")]
  public static extern void switch_stream_handle_data_size_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_data_size_get")]
  public static extern IntPtr switch_stream_handle_data_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_data_len_set")]
  public static extern void switch_stream_handle_data_len_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_data_len_get")]
  public static extern IntPtr switch_stream_handle_data_len_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_alloc_len_set")]
  public static extern void switch_stream_handle_alloc_len_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_alloc_len_get")]
  public static extern IntPtr switch_stream_handle_alloc_len_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_alloc_chunk_set")]
  public static extern void switch_stream_handle_alloc_chunk_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_alloc_chunk_get")]
  public static extern IntPtr switch_stream_handle_alloc_chunk_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_param_event_set")]
  public static extern void switch_stream_handle_param_event_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_stream_handle_param_event_get")]
  public static extern IntPtr switch_stream_handle_param_event_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_stream_handle")]
  public static extern IntPtr new_switch_stream_handle();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_stream_handle")]
  public static extern void delete_switch_stream_handle(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_outgoing_channel_set")]
  public static extern void switch_io_routines_outgoing_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_outgoing_channel_get")]
  public static extern IntPtr switch_io_routines_outgoing_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_read_frame_set")]
  public static extern void switch_io_routines_read_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_read_frame_get")]
  public static extern IntPtr switch_io_routines_read_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_write_frame_set")]
  public static extern void switch_io_routines_write_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_write_frame_get")]
  public static extern IntPtr switch_io_routines_write_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_kill_channel_set")]
  public static extern void switch_io_routines_kill_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_kill_channel_get")]
  public static extern IntPtr switch_io_routines_kill_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_send_dtmf_set")]
  public static extern void switch_io_routines_send_dtmf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_send_dtmf_get")]
  public static extern IntPtr switch_io_routines_send_dtmf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_receive_message_set")]
  public static extern void switch_io_routines_receive_message_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_receive_message_get")]
  public static extern IntPtr switch_io_routines_receive_message_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_receive_event_set")]
  public static extern void switch_io_routines_receive_event_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_receive_event_get")]
  public static extern IntPtr switch_io_routines_receive_event_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_state_change_set")]
  public static extern void switch_io_routines_state_change_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_state_change_get")]
  public static extern IntPtr switch_io_routines_state_change_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_read_video_frame_set")]
  public static extern void switch_io_routines_read_video_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_read_video_frame_get")]
  public static extern IntPtr switch_io_routines_read_video_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_write_video_frame_set")]
  public static extern void switch_io_routines_write_video_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_write_video_frame_get")]
  public static extern IntPtr switch_io_routines_write_video_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_resurrect_session_set")]
  public static extern void switch_io_routines_resurrect_session_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_resurrect_session_get")]
  public static extern IntPtr switch_io_routines_resurrect_session_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_padding_set")]
  public static extern void switch_io_routines_padding_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_routines_padding_get")]
  public static extern IntPtr switch_io_routines_padding_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_routines")]
  public static extern IntPtr new_switch_io_routines();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_routines")]
  public static extern void delete_switch_io_routines(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_interface_name_set")]
  public static extern void switch_endpoint_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_interface_name_get")]
  public static extern string switch_endpoint_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_io_routines_set")]
  public static extern void switch_endpoint_interface_io_routines_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_io_routines_get")]
  public static extern IntPtr switch_endpoint_interface_io_routines_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_state_handler_set")]
  public static extern void switch_endpoint_interface_state_handler_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_state_handler_get")]
  public static extern IntPtr switch_endpoint_interface_state_handler_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_private_info_set")]
  public static extern void switch_endpoint_interface_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_private_info_get")]
  public static extern IntPtr switch_endpoint_interface_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_next_set")]
  public static extern void switch_endpoint_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_endpoint_interface_next_get")]
  public static extern IntPtr switch_endpoint_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_endpoint_interface")]
  public static extern IntPtr new_switch_endpoint_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_endpoint_interface")]
  public static extern void delete_switch_endpoint_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interval_set")]
  public static extern void switch_timer_interval_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interval_get")]
  public static extern int switch_timer_interval_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_flags_set")]
  public static extern void switch_timer_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_flags_get")]
  public static extern uint switch_timer_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_samples_set")]
  public static extern void switch_timer_samples_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_samples_get")]
  public static extern uint switch_timer_samples_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_samplecount_set")]
  public static extern void switch_timer_samplecount_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_samplecount_get")]
  public static extern uint switch_timer_samplecount_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_timer_interface_set")]
  public static extern void switch_timer_timer_interface_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_timer_interface_get")]
  public static extern IntPtr switch_timer_timer_interface_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_memory_pool_set")]
  public static extern void switch_timer_memory_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_memory_pool_get")]
  public static extern IntPtr switch_timer_memory_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_private_info_set")]
  public static extern void switch_timer_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_private_info_get")]
  public static extern IntPtr switch_timer_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_diff_set")]
  public static extern void switch_timer_diff_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_diff_get")]
  public static extern IntPtr switch_timer_diff_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_tick_set")]
  public static extern void switch_timer_tick_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_tick_get")]
  public static extern IntPtr switch_timer_tick_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_timer")]
  public static extern IntPtr new_switch_timer();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_timer")]
  public static extern void delete_switch_timer(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_interface_name_set")]
  public static extern void switch_timer_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_interface_name_get")]
  public static extern string switch_timer_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_init_set")]
  public static extern void switch_timer_interface_timer_init_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_init_get")]
  public static extern IntPtr switch_timer_interface_timer_init_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_next_set")]
  public static extern void switch_timer_interface_timer_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_next_get")]
  public static extern IntPtr switch_timer_interface_timer_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_step_set")]
  public static extern void switch_timer_interface_timer_step_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_step_get")]
  public static extern IntPtr switch_timer_interface_timer_step_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_sync_set")]
  public static extern void switch_timer_interface_timer_sync_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_sync_get")]
  public static extern IntPtr switch_timer_interface_timer_sync_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_check_set")]
  public static extern void switch_timer_interface_timer_check_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_check_get")]
  public static extern IntPtr switch_timer_interface_timer_check_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_destroy_set")]
  public static extern void switch_timer_interface_timer_destroy_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_timer_destroy_get")]
  public static extern IntPtr switch_timer_interface_timer_destroy_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_next_set")]
  public static extern void switch_timer_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_timer_interface_next_get")]
  public static extern IntPtr switch_timer_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_timer_interface")]
  public static extern IntPtr new_switch_timer_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_timer_interface")]
  public static extern void delete_switch_timer_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dialplan_interface_interface_name_set")]
  public static extern void switch_dialplan_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dialplan_interface_interface_name_get")]
  public static extern string switch_dialplan_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dialplan_interface_hunt_function_set")]
  public static extern void switch_dialplan_interface_hunt_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dialplan_interface_hunt_function_get")]
  public static extern IntPtr switch_dialplan_interface_hunt_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dialplan_interface_next_set")]
  public static extern void switch_dialplan_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_dialplan_interface_next_get")]
  public static extern IntPtr switch_dialplan_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_dialplan_interface")]
  public static extern IntPtr new_switch_dialplan_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_dialplan_interface")]
  public static extern void delete_switch_dialplan_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_interface_name_set")]
  public static extern void switch_file_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_interface_name_get")]
  public static extern string switch_file_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_open_set")]
  public static extern void switch_file_interface_file_open_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_open_get")]
  public static extern IntPtr switch_file_interface_file_open_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_close_set")]
  public static extern void switch_file_interface_file_close_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_close_get")]
  public static extern IntPtr switch_file_interface_file_close_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_read_set")]
  public static extern void switch_file_interface_file_read_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_read_get")]
  public static extern IntPtr switch_file_interface_file_read_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_write_set")]
  public static extern void switch_file_interface_file_write_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_write_get")]
  public static extern IntPtr switch_file_interface_file_write_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_seek_set")]
  public static extern void switch_file_interface_file_seek_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_seek_get")]
  public static extern IntPtr switch_file_interface_file_seek_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_set_string_set")]
  public static extern void switch_file_interface_file_set_string_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_set_string_get")]
  public static extern IntPtr switch_file_interface_file_set_string_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_get_string_set")]
  public static extern void switch_file_interface_file_get_string_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_file_get_string_get")]
  public static extern IntPtr switch_file_interface_file_get_string_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_extens_set")]
  public static extern void switch_file_interface_extens_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_extens_get")]
  public static extern IntPtr switch_file_interface_extens_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_next_set")]
  public static extern void switch_file_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_interface_next_get")]
  public static extern IntPtr switch_file_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_file_interface")]
  public static extern IntPtr new_switch_file_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_file_interface")]
  public static extern void delete_switch_file_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_file_interface_set")]
  public static extern void switch_file_handle_file_interface_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_file_interface_get")]
  public static extern IntPtr switch_file_handle_file_interface_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_flags_set")]
  public static extern void switch_file_handle_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_flags_get")]
  public static extern uint switch_file_handle_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_fd_set")]
  public static extern void switch_file_handle_fd_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_fd_get")]
  public static extern IntPtr switch_file_handle_fd_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_samples_set")]
  public static extern void switch_file_handle_samples_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_samples_get")]
  public static extern uint switch_file_handle_samples_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_samplerate_set")]
  public static extern void switch_file_handle_samplerate_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_samplerate_get")]
  public static extern uint switch_file_handle_samplerate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_native_rate_set")]
  public static extern void switch_file_handle_native_rate_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_native_rate_get")]
  public static extern uint switch_file_handle_native_rate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_channels_set")]
  public static extern void switch_file_handle_channels_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_channels_get")]
  public static extern byte switch_file_handle_channels_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_format_set")]
  public static extern void switch_file_handle_format_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_format_get")]
  public static extern uint switch_file_handle_format_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_sections_set")]
  public static extern void switch_file_handle_sections_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_sections_get")]
  public static extern uint switch_file_handle_sections_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_seekable_set")]
  public static extern void switch_file_handle_seekable_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_seekable_get")]
  public static extern int switch_file_handle_seekable_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_sample_count_set")]
  public static extern void switch_file_handle_sample_count_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_sample_count_get")]
  public static extern IntPtr switch_file_handle_sample_count_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_speed_set")]
  public static extern void switch_file_handle_speed_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_speed_get")]
  public static extern int switch_file_handle_speed_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_memory_pool_set")]
  public static extern void switch_file_handle_memory_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_memory_pool_get")]
  public static extern IntPtr switch_file_handle_memory_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_prebuf_set")]
  public static extern void switch_file_handle_prebuf_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_prebuf_get")]
  public static extern uint switch_file_handle_prebuf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_interval_set")]
  public static extern void switch_file_handle_interval_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_interval_get")]
  public static extern uint switch_file_handle_interval_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_private_info_set")]
  public static extern void switch_file_handle_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_private_info_get")]
  public static extern IntPtr switch_file_handle_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_handler_set")]
  public static extern void switch_file_handle_handler_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_handler_get")]
  public static extern string switch_file_handle_handler_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_pos_set")]
  public static extern void switch_file_handle_pos_set(HandleRef jarg1, long jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_pos_get")]
  public static extern long switch_file_handle_pos_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_audio_buffer_set")]
  public static extern void switch_file_handle_audio_buffer_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_audio_buffer_get")]
  public static extern IntPtr switch_file_handle_audio_buffer_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_sp_audio_buffer_set")]
  public static extern void switch_file_handle_sp_audio_buffer_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_sp_audio_buffer_get")]
  public static extern IntPtr switch_file_handle_sp_audio_buffer_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_thresh_set")]
  public static extern void switch_file_handle_thresh_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_thresh_get")]
  public static extern uint switch_file_handle_thresh_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_silence_hits_set")]
  public static extern void switch_file_handle_silence_hits_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_silence_hits_get")]
  public static extern uint switch_file_handle_silence_hits_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_offset_pos_set")]
  public static extern void switch_file_handle_offset_pos_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_offset_pos_get")]
  public static extern uint switch_file_handle_offset_pos_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_last_pos_set")]
  public static extern void switch_file_handle_last_pos_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_last_pos_get")]
  public static extern uint switch_file_handle_last_pos_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_vol_set")]
  public static extern void switch_file_handle_vol_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_vol_get")]
  public static extern int switch_file_handle_vol_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_resampler_set")]
  public static extern void switch_file_handle_resampler_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_resampler_get")]
  public static extern IntPtr switch_file_handle_resampler_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_buffer_set")]
  public static extern void switch_file_handle_buffer_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_buffer_get")]
  public static extern IntPtr switch_file_handle_buffer_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_dbuf_set")]
  public static extern void switch_file_handle_dbuf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_dbuf_get")]
  public static extern IntPtr switch_file_handle_dbuf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_dbuflen_set")]
  public static extern void switch_file_handle_dbuflen_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_dbuflen_get")]
  public static extern IntPtr switch_file_handle_dbuflen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_file_set")]
  public static extern void switch_file_handle_file_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_file_get")]
  public static extern string switch_file_handle_file_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_func_set")]
  public static extern void switch_file_handle_func_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_func_get")]
  public static extern string switch_file_handle_func_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_line_set")]
  public static extern void switch_file_handle_line_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_file_handle_line_get")]
  public static extern int switch_file_handle_line_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_file_handle")]
  public static extern IntPtr new_switch_file_handle();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_file_handle")]
  public static extern void delete_switch_file_handle(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_interface_name_set")]
  public static extern void switch_asr_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_interface_name_get")]
  public static extern string switch_asr_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_open_set")]
  public static extern void switch_asr_interface_asr_open_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_open_get")]
  public static extern IntPtr switch_asr_interface_asr_open_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_load_grammar_set")]
  public static extern void switch_asr_interface_asr_load_grammar_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_load_grammar_get")]
  public static extern IntPtr switch_asr_interface_asr_load_grammar_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_unload_grammar_set")]
  public static extern void switch_asr_interface_asr_unload_grammar_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_unload_grammar_get")]
  public static extern IntPtr switch_asr_interface_asr_unload_grammar_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_close_set")]
  public static extern void switch_asr_interface_asr_close_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_close_get")]
  public static extern IntPtr switch_asr_interface_asr_close_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_feed_set")]
  public static extern void switch_asr_interface_asr_feed_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_feed_get")]
  public static extern IntPtr switch_asr_interface_asr_feed_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_resume_set")]
  public static extern void switch_asr_interface_asr_resume_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_resume_get")]
  public static extern IntPtr switch_asr_interface_asr_resume_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_pause_set")]
  public static extern void switch_asr_interface_asr_pause_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_pause_get")]
  public static extern IntPtr switch_asr_interface_asr_pause_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_check_results_set")]
  public static extern void switch_asr_interface_asr_check_results_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_check_results_get")]
  public static extern IntPtr switch_asr_interface_asr_check_results_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_get_results_set")]
  public static extern void switch_asr_interface_asr_get_results_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_asr_get_results_get")]
  public static extern IntPtr switch_asr_interface_asr_get_results_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_next_set")]
  public static extern void switch_asr_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_interface_next_get")]
  public static extern IntPtr switch_asr_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_asr_interface")]
  public static extern IntPtr new_switch_asr_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_asr_interface")]
  public static extern void delete_switch_asr_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_asr_interface_set")]
  public static extern void switch_asr_handle_asr_interface_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_asr_interface_get")]
  public static extern IntPtr switch_asr_handle_asr_interface_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_flags_set")]
  public static extern void switch_asr_handle_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_flags_get")]
  public static extern uint switch_asr_handle_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_name_set")]
  public static extern void switch_asr_handle_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_name_get")]
  public static extern string switch_asr_handle_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_codec_set")]
  public static extern void switch_asr_handle_codec_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_codec_get")]
  public static extern string switch_asr_handle_codec_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_rate_set")]
  public static extern void switch_asr_handle_rate_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_rate_get")]
  public static extern uint switch_asr_handle_rate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_grammar_set")]
  public static extern void switch_asr_handle_grammar_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_grammar_get")]
  public static extern string switch_asr_handle_grammar_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_param_set")]
  public static extern void switch_asr_handle_param_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_param_get")]
  public static extern string switch_asr_handle_param_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_memory_pool_set")]
  public static extern void switch_asr_handle_memory_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_memory_pool_get")]
  public static extern IntPtr switch_asr_handle_memory_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_private_info_set")]
  public static extern void switch_asr_handle_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_asr_handle_private_info_get")]
  public static extern IntPtr switch_asr_handle_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_asr_handle")]
  public static extern IntPtr new_switch_asr_handle();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_asr_handle")]
  public static extern void delete_switch_asr_handle(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_interface_name_set")]
  public static extern void switch_speech_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_interface_name_get")]
  public static extern string switch_speech_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_open_set")]
  public static extern void switch_speech_interface_speech_open_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_open_get")]
  public static extern IntPtr switch_speech_interface_speech_open_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_close_set")]
  public static extern void switch_speech_interface_speech_close_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_close_get")]
  public static extern IntPtr switch_speech_interface_speech_close_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_feed_tts_set")]
  public static extern void switch_speech_interface_speech_feed_tts_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_feed_tts_get")]
  public static extern IntPtr switch_speech_interface_speech_feed_tts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_read_tts_set")]
  public static extern void switch_speech_interface_speech_read_tts_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_read_tts_get")]
  public static extern IntPtr switch_speech_interface_speech_read_tts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_flush_tts_set")]
  public static extern void switch_speech_interface_speech_flush_tts_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_flush_tts_get")]
  public static extern IntPtr switch_speech_interface_speech_flush_tts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_text_param_tts_set")]
  public static extern void switch_speech_interface_speech_text_param_tts_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_text_param_tts_get")]
  public static extern IntPtr switch_speech_interface_speech_text_param_tts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_numeric_param_tts_set")]
  public static extern void switch_speech_interface_speech_numeric_param_tts_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_numeric_param_tts_get")]
  public static extern IntPtr switch_speech_interface_speech_numeric_param_tts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_float_param_tts_set")]
  public static extern void switch_speech_interface_speech_float_param_tts_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_speech_float_param_tts_get")]
  public static extern IntPtr switch_speech_interface_speech_float_param_tts_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_next_set")]
  public static extern void switch_speech_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_interface_next_get")]
  public static extern IntPtr switch_speech_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_speech_interface")]
  public static extern IntPtr new_switch_speech_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_speech_interface")]
  public static extern void delete_switch_speech_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_speech_interface_set")]
  public static extern void switch_speech_handle_speech_interface_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_speech_interface_get")]
  public static extern IntPtr switch_speech_handle_speech_interface_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_flags_set")]
  public static extern void switch_speech_handle_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_flags_get")]
  public static extern uint switch_speech_handle_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_name_set")]
  public static extern void switch_speech_handle_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_name_get")]
  public static extern string switch_speech_handle_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_rate_set")]
  public static extern void switch_speech_handle_rate_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_rate_get")]
  public static extern uint switch_speech_handle_rate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_speed_set")]
  public static extern void switch_speech_handle_speed_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_speed_get")]
  public static extern uint switch_speech_handle_speed_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_samples_set")]
  public static extern void switch_speech_handle_samples_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_samples_get")]
  public static extern uint switch_speech_handle_samples_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_voice_set")]
  public static extern void switch_speech_handle_voice_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_voice_get")]
  public static extern string switch_speech_handle_voice_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_engine_set")]
  public static extern void switch_speech_handle_engine_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_engine_get")]
  public static extern string switch_speech_handle_engine_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_param_set")]
  public static extern void switch_speech_handle_param_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_param_get")]
  public static extern string switch_speech_handle_param_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_memory_pool_set")]
  public static extern void switch_speech_handle_memory_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_memory_pool_get")]
  public static extern IntPtr switch_speech_handle_memory_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_private_info_set")]
  public static extern void switch_speech_handle_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_speech_handle_private_info_get")]
  public static extern IntPtr switch_speech_handle_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_speech_handle")]
  public static extern IntPtr new_switch_speech_handle();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_speech_handle")]
  public static extern void delete_switch_speech_handle(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_say_interface_interface_name_set")]
  public static extern void switch_say_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_say_interface_interface_name_get")]
  public static extern string switch_say_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_say_interface_say_function_set")]
  public static extern void switch_say_interface_say_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_say_interface_say_function_get")]
  public static extern IntPtr switch_say_interface_say_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_say_interface_next_set")]
  public static extern void switch_say_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_say_interface_next_get")]
  public static extern IntPtr switch_say_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_say_interface")]
  public static extern IntPtr new_switch_say_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_say_interface")]
  public static extern void delete_switch_say_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_chat_interface_interface_name_set")]
  public static extern void switch_chat_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_chat_interface_interface_name_get")]
  public static extern string switch_chat_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_chat_interface_chat_send_set")]
  public static extern void switch_chat_interface_chat_send_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_chat_interface_chat_send_get")]
  public static extern IntPtr switch_chat_interface_chat_send_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_chat_interface_next_set")]
  public static extern void switch_chat_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_chat_interface_next_get")]
  public static extern IntPtr switch_chat_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_chat_interface")]
  public static extern IntPtr new_switch_chat_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_chat_interface")]
  public static extern void delete_switch_chat_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_management_interface_relative_oid_set")]
  public static extern void switch_management_interface_relative_oid_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_management_interface_relative_oid_get")]
  public static extern string switch_management_interface_relative_oid_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_management_interface_management_function_set")]
  public static extern void switch_management_interface_management_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_management_interface_management_function_get")]
  public static extern IntPtr switch_management_interface_management_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_management_interface_next_set")]
  public static extern void switch_management_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_management_interface_next_get")]
  public static extern IntPtr switch_management_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_management_interface")]
  public static extern IntPtr new_switch_management_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_management_interface")]
  public static extern void delete_switch_management_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_interface_name_set")]
  public static extern void switch_directory_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_interface_name_get")]
  public static extern string switch_directory_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_open_set")]
  public static extern void switch_directory_interface_directory_open_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_open_get")]
  public static extern IntPtr switch_directory_interface_directory_open_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_close_set")]
  public static extern void switch_directory_interface_directory_close_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_close_get")]
  public static extern IntPtr switch_directory_interface_directory_close_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_query_set")]
  public static extern void switch_directory_interface_directory_query_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_query_get")]
  public static extern IntPtr switch_directory_interface_directory_query_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_next_set")]
  public static extern void switch_directory_interface_directory_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_next_get")]
  public static extern IntPtr switch_directory_interface_directory_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_next_pair_set")]
  public static extern void switch_directory_interface_directory_next_pair_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_directory_next_pair_get")]
  public static extern IntPtr switch_directory_interface_directory_next_pair_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_next_set")]
  public static extern void switch_directory_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_interface_next_get")]
  public static extern IntPtr switch_directory_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_directory_interface")]
  public static extern IntPtr new_switch_directory_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_directory_interface")]
  public static extern void delete_switch_directory_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_directory_interface_set")]
  public static extern void switch_directory_handle_directory_interface_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_directory_interface_get")]
  public static extern IntPtr switch_directory_handle_directory_interface_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_flags_set")]
  public static extern void switch_directory_handle_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_flags_get")]
  public static extern uint switch_directory_handle_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_memory_pool_set")]
  public static extern void switch_directory_handle_memory_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_memory_pool_get")]
  public static extern IntPtr switch_directory_handle_memory_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_private_info_set")]
  public static extern void switch_directory_handle_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_directory_handle_private_info_get")]
  public static extern IntPtr switch_directory_handle_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_directory_handle")]
  public static extern IntPtr new_switch_directory_handle();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_directory_handle")]
  public static extern void delete_switch_directory_handle(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_quality_set")]
  public static extern void switch_codec_settings_quality_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_quality_get")]
  public static extern int switch_codec_settings_quality_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_complexity_set")]
  public static extern void switch_codec_settings_complexity_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_complexity_get")]
  public static extern int switch_codec_settings_complexity_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_enhancement_set")]
  public static extern void switch_codec_settings_enhancement_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_enhancement_get")]
  public static extern int switch_codec_settings_enhancement_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_vad_set")]
  public static extern void switch_codec_settings_vad_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_vad_get")]
  public static extern int switch_codec_settings_vad_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_vbr_set")]
  public static extern void switch_codec_settings_vbr_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_vbr_get")]
  public static extern int switch_codec_settings_vbr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_vbr_quality_set")]
  public static extern void switch_codec_settings_vbr_quality_set(HandleRef jarg1, float jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_vbr_quality_get")]
  public static extern float switch_codec_settings_vbr_quality_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_abr_set")]
  public static extern void switch_codec_settings_abr_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_abr_get")]
  public static extern int switch_codec_settings_abr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_dtx_set")]
  public static extern void switch_codec_settings_dtx_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_dtx_get")]
  public static extern int switch_codec_settings_dtx_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_preproc_set")]
  public static extern void switch_codec_settings_preproc_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_preproc_get")]
  public static extern int switch_codec_settings_preproc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_vad_set")]
  public static extern void switch_codec_settings_pp_vad_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_vad_get")]
  public static extern int switch_codec_settings_pp_vad_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_agc_set")]
  public static extern void switch_codec_settings_pp_agc_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_agc_get")]
  public static extern int switch_codec_settings_pp_agc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_agc_level_set")]
  public static extern void switch_codec_settings_pp_agc_level_set(HandleRef jarg1, float jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_agc_level_get")]
  public static extern float switch_codec_settings_pp_agc_level_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_denoise_set")]
  public static extern void switch_codec_settings_pp_denoise_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_denoise_get")]
  public static extern int switch_codec_settings_pp_denoise_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_dereverb_set")]
  public static extern void switch_codec_settings_pp_dereverb_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_dereverb_get")]
  public static extern int switch_codec_settings_pp_dereverb_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_dereverb_decay_set")]
  public static extern void switch_codec_settings_pp_dereverb_decay_set(HandleRef jarg1, float jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_dereverb_decay_get")]
  public static extern float switch_codec_settings_pp_dereverb_decay_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_dereverb_level_set")]
  public static extern void switch_codec_settings_pp_dereverb_level_set(HandleRef jarg1, float jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_settings_pp_dereverb_level_get")]
  public static extern float switch_codec_settings_pp_dereverb_level_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_codec_settings")]
  public static extern IntPtr new_switch_codec_settings();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_codec_settings")]
  public static extern void delete_switch_codec_settings(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_codec_interface_set")]
  public static extern void switch_codec_codec_interface_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_codec_interface_get")]
  public static extern IntPtr switch_codec_codec_interface_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_set")]
  public static extern void switch_codec_implementation_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_get")]
  public static extern IntPtr switch_codec_implementation_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_fmtp_in_set")]
  public static extern void switch_codec_fmtp_in_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_fmtp_in_get")]
  public static extern string switch_codec_fmtp_in_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_fmtp_out_set")]
  public static extern void switch_codec_fmtp_out_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_fmtp_out_get")]
  public static extern string switch_codec_fmtp_out_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_codec_settings_set")]
  public static extern void switch_codec_codec_settings_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_codec_settings_get")]
  public static extern IntPtr switch_codec_codec_settings_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_flags_set")]
  public static extern void switch_codec_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_flags_get")]
  public static extern uint switch_codec_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_memory_pool_set")]
  public static extern void switch_codec_memory_pool_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_memory_pool_get")]
  public static extern IntPtr switch_codec_memory_pool_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_private_info_set")]
  public static extern void switch_codec_private_info_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_private_info_get")]
  public static extern IntPtr switch_codec_private_info_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_agreed_pt_set")]
  public static extern void switch_codec_agreed_pt_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_agreed_pt_get")]
  public static extern byte switch_codec_agreed_pt_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_codec")]
  public static extern IntPtr new_switch_codec();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_codec")]
  public static extern void delete_switch_codec(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_codec_type_set")]
  public static extern void switch_codec_implementation_codec_type_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_codec_type_get")]
  public static extern int switch_codec_implementation_codec_type_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_ianacode_set")]
  public static extern void switch_codec_implementation_ianacode_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_ianacode_get")]
  public static extern byte switch_codec_implementation_ianacode_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_iananame_set")]
  public static extern void switch_codec_implementation_iananame_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_iananame_get")]
  public static extern string switch_codec_implementation_iananame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_fmtp_set")]
  public static extern void switch_codec_implementation_fmtp_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_fmtp_get")]
  public static extern string switch_codec_implementation_fmtp_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_samples_per_second_set")]
  public static extern void switch_codec_implementation_samples_per_second_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_samples_per_second_get")]
  public static extern uint switch_codec_implementation_samples_per_second_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_actual_samples_per_second_set")]
  public static extern void switch_codec_implementation_actual_samples_per_second_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_actual_samples_per_second_get")]
  public static extern uint switch_codec_implementation_actual_samples_per_second_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_bits_per_second_set")]
  public static extern void switch_codec_implementation_bits_per_second_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_bits_per_second_get")]
  public static extern int switch_codec_implementation_bits_per_second_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_microseconds_per_frame_set")]
  public static extern void switch_codec_implementation_microseconds_per_frame_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_microseconds_per_frame_get")]
  public static extern int switch_codec_implementation_microseconds_per_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_samples_per_frame_set")]
  public static extern void switch_codec_implementation_samples_per_frame_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_samples_per_frame_get")]
  public static extern uint switch_codec_implementation_samples_per_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_bytes_per_frame_set")]
  public static extern void switch_codec_implementation_bytes_per_frame_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_bytes_per_frame_get")]
  public static extern uint switch_codec_implementation_bytes_per_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_encoded_bytes_per_frame_set")]
  public static extern void switch_codec_implementation_encoded_bytes_per_frame_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_encoded_bytes_per_frame_get")]
  public static extern uint switch_codec_implementation_encoded_bytes_per_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_number_of_channels_set")]
  public static extern void switch_codec_implementation_number_of_channels_set(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_number_of_channels_get")]
  public static extern byte switch_codec_implementation_number_of_channels_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_pref_frames_per_packet_set")]
  public static extern void switch_codec_implementation_pref_frames_per_packet_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_pref_frames_per_packet_get")]
  public static extern int switch_codec_implementation_pref_frames_per_packet_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_max_frames_per_packet_set")]
  public static extern void switch_codec_implementation_max_frames_per_packet_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_max_frames_per_packet_get")]
  public static extern int switch_codec_implementation_max_frames_per_packet_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_init_set")]
  public static extern void switch_codec_implementation_init_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_init_get")]
  public static extern IntPtr switch_codec_implementation_init_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_encode_set")]
  public static extern void switch_codec_implementation_encode_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_encode_get")]
  public static extern IntPtr switch_codec_implementation_encode_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_decode_set")]
  public static extern void switch_codec_implementation_decode_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_decode_get")]
  public static extern IntPtr switch_codec_implementation_decode_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_destroy_set")]
  public static extern void switch_codec_implementation_destroy_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_destroy_get")]
  public static extern IntPtr switch_codec_implementation_destroy_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_codec_id_set")]
  public static extern void switch_codec_implementation_codec_id_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_codec_id_get")]
  public static extern uint switch_codec_implementation_codec_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_next_set")]
  public static extern void switch_codec_implementation_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_implementation_next_get")]
  public static extern IntPtr switch_codec_implementation_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_codec_implementation")]
  public static extern IntPtr new_switch_codec_implementation();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_codec_implementation")]
  public static extern void delete_switch_codec_implementation(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_interface_name_set")]
  public static extern void switch_codec_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_interface_name_get")]
  public static extern string switch_codec_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_implementations_set")]
  public static extern void switch_codec_interface_implementations_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_implementations_get")]
  public static extern IntPtr switch_codec_interface_implementations_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_codec_id_set")]
  public static extern void switch_codec_interface_codec_id_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_codec_id_get")]
  public static extern uint switch_codec_interface_codec_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_next_set")]
  public static extern void switch_codec_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_codec_interface_next_get")]
  public static extern IntPtr switch_codec_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_codec_interface")]
  public static extern IntPtr new_switch_codec_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_codec_interface")]
  public static extern void delete_switch_codec_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_interface_name_set")]
  public static extern void switch_application_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_interface_name_get")]
  public static extern string switch_application_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_application_function_set")]
  public static extern void switch_application_interface_application_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_application_function_get")]
  public static extern IntPtr switch_application_interface_application_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_long_desc_set")]
  public static extern void switch_application_interface_long_desc_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_long_desc_get")]
  public static extern string switch_application_interface_long_desc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_short_desc_set")]
  public static extern void switch_application_interface_short_desc_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_short_desc_get")]
  public static extern string switch_application_interface_short_desc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_syntax_set")]
  public static extern void switch_application_interface_syntax_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_syntax_get")]
  public static extern string switch_application_interface_syntax_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_flags_set")]
  public static extern void switch_application_interface_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_flags_get")]
  public static extern uint switch_application_interface_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_next_set")]
  public static extern void switch_application_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_application_interface_next_get")]
  public static extern IntPtr switch_application_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_application_interface")]
  public static extern IntPtr new_switch_application_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_application_interface")]
  public static extern void delete_switch_application_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_interface_name_set")]
  public static extern void switch_api_interface_interface_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_interface_name_get")]
  public static extern string switch_api_interface_interface_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_desc_set")]
  public static extern void switch_api_interface_desc_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_desc_get")]
  public static extern string switch_api_interface_desc_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_function_set")]
  public static extern void switch_api_interface_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_function_get")]
  public static extern IntPtr switch_api_interface_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_syntax_set")]
  public static extern void switch_api_interface_syntax_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_syntax_get")]
  public static extern string switch_api_interface_syntax_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_next_set")]
  public static extern void switch_api_interface_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_api_interface_next_get")]
  public static extern IntPtr switch_api_interface_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_api_interface")]
  public static extern IntPtr new_switch_api_interface();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_api_interface")]
  public static extern void delete_switch_api_interface(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_profile_created_set")]
  public static extern void switch_channel_timetable_profile_created_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_profile_created_get")]
  public static extern IntPtr switch_channel_timetable_profile_created_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_created_set")]
  public static extern void switch_channel_timetable_created_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_created_get")]
  public static extern IntPtr switch_channel_timetable_created_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_answered_set")]
  public static extern void switch_channel_timetable_answered_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_answered_get")]
  public static extern IntPtr switch_channel_timetable_answered_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_progress_set")]
  public static extern void switch_channel_timetable_progress_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_progress_get")]
  public static extern IntPtr switch_channel_timetable_progress_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_progress_media_set")]
  public static extern void switch_channel_timetable_progress_media_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_progress_media_get")]
  public static extern IntPtr switch_channel_timetable_progress_media_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_hungup_set")]
  public static extern void switch_channel_timetable_hungup_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_hungup_get")]
  public static extern IntPtr switch_channel_timetable_hungup_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_transferred_set")]
  public static extern void switch_channel_timetable_transferred_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_transferred_get")]
  public static extern IntPtr switch_channel_timetable_transferred_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_next_set")]
  public static extern void switch_channel_timetable_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_timetable_next_get")]
  public static extern IntPtr switch_channel_timetable_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_channel_timetable")]
  public static extern IntPtr new_switch_channel_timetable();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_channel_timetable")]
  public static extern void delete_switch_channel_timetable(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_state")]
  public static extern int switch_channel_get_state(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_running_state")]
  public static extern int switch_channel_get_running_state(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_ready")]
  public static extern byte switch_channel_ready(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_wait_for_state")]
  public static extern void switch_channel_wait_for_state(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_wait_for_flag")]
  public static extern int switch_channel_wait_for_flag(HandleRef jarg1, int jarg2, int jarg3, uint jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_set_state")]
  public static extern int switch_channel_perform_set_state(HandleRef jarg1, string jarg2, string jarg3, int jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_set_running_state")]
  public static extern int switch_channel_perform_set_running_state(HandleRef jarg1, int jarg2, string jarg3, string jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_str2cause")]
  public static extern int switch_channel_str2cause(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_cause")]
  public static extern int switch_channel_get_cause(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_cause2str")]
  public static extern string switch_channel_cause2str(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_timetable")]
  public static extern IntPtr switch_channel_get_timetable(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_alloc")]
  public static extern int switch_channel_alloc(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_init")]
  public static extern int switch_channel_init(HandleRef jarg1, HandleRef jarg2, int jarg3, uint jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_presence")]
  public static extern void switch_channel_presence(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_uninit")]
  public static extern void switch_channel_uninit(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_caller_profile")]
  public static extern void switch_channel_set_caller_profile(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_caller_profile")]
  public static extern IntPtr switch_channel_get_caller_profile(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_originator_caller_profile")]
  public static extern void switch_channel_set_originator_caller_profile(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_originator_caller_profile")]
  public static extern IntPtr switch_channel_get_originator_caller_profile(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_originatee_caller_profile")]
  public static extern void switch_channel_set_originatee_caller_profile(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_originatee_caller_profile")]
  public static extern IntPtr switch_channel_get_originatee_caller_profile(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_uuid")]
  public static extern string switch_channel_get_uuid(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_variable")]
  public static extern int switch_channel_set_variable(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_variable_partner")]
  public static extern int switch_channel_set_variable_partner(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_variable_partner")]
  public static extern string switch_channel_get_variable_partner(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_variable")]
  public static extern string switch_channel_get_variable(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_variable_first")]
  public static extern IntPtr switch_channel_variable_first(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_variable_last")]
  public static extern void switch_channel_variable_last(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_caller_extension")]
  public static extern void switch_channel_set_caller_extension(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_caller_extension")]
  public static extern IntPtr switch_channel_get_caller_extension(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_test_flag")]
  public static extern uint switch_channel_test_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_flag")]
  public static extern void switch_channel_set_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_flag_partner")]
  public static extern int switch_channel_set_flag_partner(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_clear_flag_partner")]
  public static extern int switch_channel_clear_flag_partner(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_state_flag")]
  public static extern void switch_channel_set_state_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_clear_flag")]
  public static extern void switch_channel_clear_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_answer")]
  public static extern int switch_channel_perform_answer(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_mark_answered")]
  public static extern int switch_channel_perform_mark_answered(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_ring_ready")]
  public static extern int switch_channel_perform_ring_ready(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_pre_answer")]
  public static extern int switch_channel_perform_pre_answer(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_mark_pre_answered")]
  public static extern int switch_channel_perform_mark_pre_answered(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_mark_ring_ready")]
  public static extern int switch_channel_perform_mark_ring_ready(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_add_state_handler")]
  public static extern int switch_channel_add_state_handler(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_clear_state_handler")]
  public static extern void switch_channel_clear_state_handler(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_state_handler")]
  public static extern IntPtr switch_channel_get_state_handler(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_private")]
  public static extern int switch_channel_set_private(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_private")]
  public static extern IntPtr switch_channel_get_private(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_name")]
  public static extern int switch_channel_set_name(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_get_name")]
  public static extern string switch_channel_get_name(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_perform_hangup")]
  public static extern int switch_channel_perform_hangup(HandleRef jarg1, string jarg2, string jarg3, int jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_has_dtmf")]
  public static extern IntPtr switch_channel_has_dtmf(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_queue_dtmf")]
  public static extern int switch_channel_queue_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_queue_dtmf_string")]
  public static extern int switch_channel_queue_dtmf_string(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_dequeue_dtmf")]
  public static extern int switch_channel_dequeue_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_flush_dtmf")]
  public static extern void switch_channel_flush_dtmf(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_dequeue_dtmf_string")]
  public static extern IntPtr switch_channel_dequeue_dtmf_string(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_state_name")]
  public static extern string switch_channel_state_name(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_name_state")]
  public static extern int switch_channel_name_state(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_event_set_data")]
  public static extern void switch_channel_event_set_data(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_expand_variables")]
  public static extern string switch_channel_expand_variables(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_build_param_string")]
  public static extern string switch_channel_build_param_string(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_channel_set_timestamps")]
  public static extern int switch_channel_set_timestamps(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_create")]
  public static extern int switch_buffer_create(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_create_dynamic")]
  public static extern int switch_buffer_create_dynamic(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_add_mutex")]
  public static extern void switch_buffer_add_mutex(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_lock")]
  public static extern void switch_buffer_lock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_trylock")]
  public static extern int switch_buffer_trylock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_unlock")]
  public static extern void switch_buffer_unlock(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_len")]
  public static extern IntPtr switch_buffer_len(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_freespace")]
  public static extern IntPtr switch_buffer_freespace(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_inuse")]
  public static extern IntPtr switch_buffer_inuse(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_read")]
  public static extern IntPtr switch_buffer_read(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_read_loop")]
  public static extern IntPtr switch_buffer_read_loop(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_set_loops")]
  public static extern void switch_buffer_set_loops(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_write")]
  public static extern IntPtr switch_buffer_write(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_toss")]
  public static extern IntPtr switch_buffer_toss(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_zero")]
  public static extern void switch_buffer_zero(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_destroy")]
  public static extern void switch_buffer_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_buffer_zwrite")]
  public static extern IntPtr switch_buffer_zwrite(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_header_name_set")]
  public static extern void switch_event_header_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_header_name_get")]
  public static extern string switch_event_header_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_header_value_set")]
  public static extern void switch_event_header_value_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_header_value_get")]
  public static extern string switch_event_header_value_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_header_next_set")]
  public static extern void switch_event_header_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_header_next_get")]
  public static extern IntPtr switch_event_header_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_event_header")]
  public static extern IntPtr new_switch_event_header();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_event_header")]
  public static extern void delete_switch_event_header(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_subclass_owner_set")]
  public static extern void switch_event_subclass_owner_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_subclass_owner_get")]
  public static extern string switch_event_subclass_owner_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_subclass_name_set")]
  public static extern void switch_event_subclass_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_subclass_name_get")]
  public static extern string switch_event_subclass_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_event_subclass")]
  public static extern IntPtr new_switch_event_subclass();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_event_subclass")]
  public static extern void delete_switch_event_subclass(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_event_id_set")]
  public static extern void switch_event_event_id_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_event_id_get")]
  public static extern int switch_event_event_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_priority_set")]
  public static extern void switch_event_priority_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_priority_get")]
  public static extern int switch_event_priority_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_owner_set")]
  public static extern void switch_event_owner_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_owner_get")]
  public static extern string switch_event_owner_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_subclass_set")]
  public static extern void switch_event_subclass_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_subclass_get")]
  public static extern IntPtr switch_event_subclass_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_headers_set")]
  public static extern void switch_event_headers_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_headers_get")]
  public static extern IntPtr switch_event_headers_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_last_header_set")]
  public static extern void switch_event_last_header_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_last_header_get")]
  public static extern IntPtr switch_event_last_header_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_body_set")]
  public static extern void switch_event_body_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_body_get")]
  public static extern string switch_event_body_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_bind_user_data_set")]
  public static extern void switch_event_bind_user_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_bind_user_data_get")]
  public static extern IntPtr switch_event_bind_user_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_event_user_data_set")]
  public static extern void switch_event_event_user_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_event_user_data_get")]
  public static extern IntPtr switch_event_event_user_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_key_set")]
  public static extern void switch_event_key_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_key_get")]
  public static extern uint switch_event_key_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_next_set")]
  public static extern void switch_event_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_next_get")]
  public static extern IntPtr switch_event_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_event")]
  public static extern IntPtr new_switch_event();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_event")]
  public static extern void delete_switch_event(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_id_set")]
  public static extern void switch_event_node_id_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_id_get")]
  public static extern string switch_event_node_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_event_id_set")]
  public static extern void switch_event_node_event_id_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_event_id_get")]
  public static extern int switch_event_node_event_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_subclass_set")]
  public static extern void switch_event_node_subclass_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_subclass_get")]
  public static extern IntPtr switch_event_node_subclass_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_callback_set")]
  public static extern void switch_event_node_callback_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_callback_get")]
  public static extern IntPtr switch_event_node_callback_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_user_data_set")]
  public static extern void switch_event_node_user_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_user_data_get")]
  public static extern IntPtr switch_event_node_user_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_next_set")]
  public static extern void switch_event_node_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_node_next_get")]
  public static extern IntPtr switch_event_node_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_event_node")]
  public static extern IntPtr new_switch_event_node();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_event_node")]
  public static extern void delete_switch_event_node(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_init")]
  public static extern int switch_event_init(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_shutdown")]
  public static extern int switch_event_shutdown();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_create_subclass")]
  public static extern int switch_event_create_subclass(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_set_priority")]
  public static extern int switch_event_set_priority(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_get_header")]
  public static extern string switch_event_get_header(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_get_body")]
  public static extern string switch_event_get_body(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_add_header_string")]
  public static extern int switch_event_add_header_string(HandleRef jarg1, int jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_del_header")]
  public static extern int switch_event_del_header(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_destroy")]
  public static extern void switch_event_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_dup")]
  public static extern int switch_event_dup(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_fire_detailed")]
  public static extern int switch_event_fire_detailed(string jarg1, string jarg2, int jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_bind")]
  public static extern int switch_event_bind(string jarg1, int jarg2, string jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_name")]
  public static extern string switch_event_name(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_name_event")]
  public static extern int switch_name_event(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_reserve_subclass_detailed")]
  public static extern int switch_event_reserve_subclass_detailed(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_serialize")]
  public static extern int switch_event_serialize(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_running")]
  public static extern int switch_event_running();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_expand_headers")]
  public static extern string switch_event_expand_headers(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_create_pres_in_detailed")]
  public static extern int switch_event_create_pres_in_detailed(string jarg1, string jarg2, int jarg3, string jarg4, string jarg5, string jarg6, string jarg7, string jarg8, string jarg9, string jarg10, int jarg11, string jarg12, string jarg13, string jarg14, string jarg15);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_deliver")]
  public static extern void switch_event_deliver(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_event_build_param_string")]
  public static extern string switch_event_build_param_string(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_resampler_set")]
  public static extern void switch_audio_resampler_t_resampler_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_resampler_get")]
  public static extern IntPtr switch_audio_resampler_t_resampler_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_rate_set")]
  public static extern void switch_audio_resampler_t_from_rate_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_rate_get")]
  public static extern int switch_audio_resampler_t_from_rate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_rate_set")]
  public static extern void switch_audio_resampler_t_to_rate_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_rate_get")]
  public static extern int switch_audio_resampler_t_to_rate_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_factor_set")]
  public static extern void switch_audio_resampler_t_factor_set(HandleRef jarg1, double jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_factor_get")]
  public static extern double switch_audio_resampler_t_factor_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_set")]
  public static extern void switch_audio_resampler_t_from_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_get")]
  public static extern IntPtr switch_audio_resampler_t_from_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_len_set")]
  public static extern void switch_audio_resampler_t_from_len_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_len_get")]
  public static extern int switch_audio_resampler_t_from_len_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_size_set")]
  public static extern void switch_audio_resampler_t_from_size_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_from_size_get")]
  public static extern IntPtr switch_audio_resampler_t_from_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_set")]
  public static extern void switch_audio_resampler_t_to_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_get")]
  public static extern IntPtr switch_audio_resampler_t_to_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_len_set")]
  public static extern void switch_audio_resampler_t_to_len_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_len_get")]
  public static extern uint switch_audio_resampler_t_to_len_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_size_set")]
  public static extern void switch_audio_resampler_t_to_size_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_audio_resampler_t_to_size_get")]
  public static extern uint switch_audio_resampler_t_to_size_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_audio_resampler_t")]
  public static extern IntPtr new_switch_audio_resampler_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_audio_resampler_t")]
  public static extern void delete_switch_audio_resampler_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_resample_create")]
  public static extern int switch_resample_create(HandleRef jarg1, int jarg2, HandleRef jarg3, int jarg4, uint jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_resample_destroy")]
  public static extern void switch_resample_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_resample_process")]
  public static extern uint switch_resample_process(HandleRef jarg1, HandleRef jarg2, int jarg3, HandleRef jarg4, uint jarg5, int jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_float_to_short")]
  public static extern IntPtr switch_float_to_short(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_char_to_float")]
  public static extern int switch_char_to_float(string jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_float_to_char")]
  public static extern int switch_float_to_char(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_short_to_float")]
  public static extern int switch_short_to_float(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_swap_linear")]
  public static extern void switch_swap_linear(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_generate_sln_silence")]
  public static extern void switch_generate_sln_silence(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_change_sln_volume")]
  public static extern void switch_change_sln_volume(HandleRef jarg1, uint jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_merge_sln")]
  public static extern uint switch_merge_sln(HandleRef jarg1, uint jarg2, HandleRef jarg3, uint jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_session_set")]
  public static extern void switch_unicast_conninfo_session_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_session_get")]
  public static extern IntPtr switch_unicast_conninfo_session_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_read_codec_set")]
  public static extern void switch_unicast_conninfo_read_codec_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_read_codec_get")]
  public static extern IntPtr switch_unicast_conninfo_read_codec_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_write_frame_set")]
  public static extern void switch_unicast_conninfo_write_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_write_frame_get")]
  public static extern IntPtr switch_unicast_conninfo_write_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_write_frame_data_set")]
  public static extern void switch_unicast_conninfo_write_frame_data_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_write_frame_data_get")]
  public static extern IntPtr switch_unicast_conninfo_write_frame_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_socket_set")]
  public static extern void switch_unicast_conninfo_socket_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_socket_get")]
  public static extern IntPtr switch_unicast_conninfo_socket_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_local_ip_set")]
  public static extern void switch_unicast_conninfo_local_ip_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_local_ip_get")]
  public static extern string switch_unicast_conninfo_local_ip_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_local_port_set")]
  public static extern void switch_unicast_conninfo_local_port_set(HandleRef jarg1, ushort jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_local_port_get")]
  public static extern ushort switch_unicast_conninfo_local_port_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_remote_ip_set")]
  public static extern void switch_unicast_conninfo_remote_ip_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_remote_ip_get")]
  public static extern string switch_unicast_conninfo_remote_ip_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_remote_port_set")]
  public static extern void switch_unicast_conninfo_remote_port_set(HandleRef jarg1, ushort jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_remote_port_get")]
  public static extern ushort switch_unicast_conninfo_remote_port_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_local_addr_set")]
  public static extern void switch_unicast_conninfo_local_addr_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_local_addr_get")]
  public static extern IntPtr switch_unicast_conninfo_local_addr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_remote_addr_set")]
  public static extern void switch_unicast_conninfo_remote_addr_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_remote_addr_get")]
  public static extern IntPtr switch_unicast_conninfo_remote_addr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_flag_mutex_set")]
  public static extern void switch_unicast_conninfo_flag_mutex_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_flag_mutex_get")]
  public static extern IntPtr switch_unicast_conninfo_flag_mutex_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_flags_set")]
  public static extern void switch_unicast_conninfo_flags_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_flags_get")]
  public static extern int switch_unicast_conninfo_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_type_set")]
  public static extern void switch_unicast_conninfo_type_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_type_get")]
  public static extern int switch_unicast_conninfo_type_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_transport_set")]
  public static extern void switch_unicast_conninfo_transport_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_transport_get")]
  public static extern int switch_unicast_conninfo_transport_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_stream_id_set")]
  public static extern void switch_unicast_conninfo_stream_id_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_unicast_conninfo_stream_id_get")]
  public static extern int switch_unicast_conninfo_stream_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_unicast_conninfo")]
  public static extern IntPtr new_switch_unicast_conninfo();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_unicast_conninfo")]
  public static extern void delete_switch_unicast_conninfo(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_deactivate_unicast")]
  public static extern int switch_ivr_deactivate_unicast(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_activate_unicast")]
  public static extern int switch_ivr_activate_unicast(HandleRef jarg1, string jarg2, ushort jarg3, string jarg4, ushort jarg5, string jarg6, string jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_generate_xml_cdr")]
  public static extern int switch_ivr_generate_xml_cdr(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_set_xml_profile_data")]
  public static extern int switch_ivr_set_xml_profile_data(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_set_xml_chan_vars")]
  public static extern int switch_ivr_set_xml_chan_vars(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_parse_event")]
  public static extern int switch_ivr_parse_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_parse_all_events")]
  public static extern int switch_ivr_parse_all_events(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_parse_next_event")]
  public static extern int switch_ivr_parse_next_event(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_sleep")]
  public static extern int switch_ivr_sleep(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_park")]
  public static extern int switch_ivr_park(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_collect_digits_callback")]
  public static extern int switch_ivr_collect_digits_callback(HandleRef jarg1, HandleRef jarg2, uint jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_collect_digits_count")]
  public static extern int switch_ivr_collect_digits_count(HandleRef jarg1, string jarg2, HandleRef jarg3, HandleRef jarg4, string jarg5, string jarg6, uint jarg7, uint jarg8, uint jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_detect_speech")]
  public static extern int switch_ivr_detect_speech(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_stop_detect_speech")]
  public static extern int switch_ivr_stop_detect_speech(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_pause_detect_speech")]
  public static extern int switch_ivr_pause_detect_speech(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_resume_detect_speech")]
  public static extern int switch_ivr_resume_detect_speech(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_detect_speech_load_grammar")]
  public static extern int switch_ivr_detect_speech_load_grammar(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_detect_speech_unload_grammar")]
  public static extern int switch_ivr_detect_speech_unload_grammar(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_record_session")]
  public static extern int switch_ivr_record_session(HandleRef jarg1, string jarg2, uint jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_eavesdrop_session")]
  public static extern int switch_ivr_eavesdrop_session(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_displace_session")]
  public static extern int switch_ivr_displace_session(HandleRef jarg1, string jarg2, uint jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_stop_displace_session")]
  public static extern int switch_ivr_stop_displace_session(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_stop_record_session")]
  public static extern int switch_ivr_stop_record_session(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_inband_dtmf_session")]
  public static extern int switch_ivr_inband_dtmf_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_stop_inband_dtmf_session")]
  public static extern int switch_ivr_stop_inband_dtmf_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_inband_dtmf_generate_session")]
  public static extern int switch_ivr_inband_dtmf_generate_session(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_stop_inband_dtmf_generate_session")]
  public static extern int switch_ivr_stop_inband_dtmf_generate_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_session_echo")]
  public static extern void switch_ivr_session_echo(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_stop_tone_detect_session")]
  public static extern int switch_ivr_stop_tone_detect_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_tone_detect_session")]
  public static extern int switch_ivr_tone_detect_session(HandleRef jarg1, string jarg2, string jarg3, string jarg4, HandleRef jarg5, string jarg6, string jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_play_file")]
  public static extern int switch_ivr_play_file(HandleRef jarg1, HandleRef jarg2, string jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_gentones")]
  public static extern int switch_ivr_gentones(HandleRef jarg1, string jarg2, int jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_record_file")]
  public static extern int switch_ivr_record_file(HandleRef jarg1, HandleRef jarg2, string jarg3, HandleRef jarg4, uint jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_play_and_get_digits")]
  public static extern int switch_play_and_get_digits(HandleRef jarg1, uint jarg2, uint jarg3, uint jarg4, uint jarg5, string jarg6, string jarg7, string jarg8, HandleRef jarg9, uint jarg10, string jarg11);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_speak_text_handle")]
  public static extern int switch_ivr_speak_text_handle(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, string jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_clear_speech_cache")]
  public static extern void switch_ivr_clear_speech_cache(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_speak_text")]
  public static extern int switch_ivr_speak_text(HandleRef jarg1, string jarg2, string jarg3, string jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_originate")]
  public static extern int switch_ivr_originate(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, string jarg4, uint jarg5, HandleRef jarg6, string jarg7, string jarg8, HandleRef jarg9, int jarg10);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_multi_threaded_bridge")]
  public static extern int switch_ivr_multi_threaded_bridge(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_signal_bridge")]
  public static extern int switch_ivr_signal_bridge(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_session_transfer")]
  public static extern int switch_ivr_session_transfer(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_schedule_transfer")]
  public static extern uint switch_ivr_schedule_transfer(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_schedule_hangup")]
  public static extern uint switch_ivr_schedule_hangup(HandleRef jarg1, string jarg2, int jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_uuid_bridge")]
  public static extern int switch_ivr_uuid_bridge(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_media")]
  public static extern int switch_ivr_media(string jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_nomedia")]
  public static extern int switch_ivr_nomedia(string jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_hold_uuid")]
  public static extern int switch_ivr_hold_uuid(string jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_unhold_uuid")]
  public static extern int switch_ivr_unhold_uuid(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_hold")]
  public static extern int switch_ivr_hold(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_unhold")]
  public static extern int switch_ivr_unhold(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_schedule_broadcast")]
  public static extern uint switch_ivr_schedule_broadcast(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_broadcast")]
  public static extern int switch_ivr_broadcast(string jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_transfer_variable")]
  public static extern int switch_ivr_transfer_variable(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_parser_new")]
  public static extern int switch_ivr_digit_stream_parser_new(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_parser_destroy")]
  public static extern int switch_ivr_digit_stream_parser_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_new")]
  public static extern int switch_ivr_digit_stream_new(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_destroy")]
  public static extern int switch_ivr_digit_stream_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_parser_set_event")]
  public static extern int switch_ivr_digit_stream_parser_set_event(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_parser_del_event")]
  public static extern int switch_ivr_digit_stream_parser_del_event(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_parser_feed")]
  public static extern IntPtr switch_ivr_digit_stream_parser_feed(HandleRef jarg1, HandleRef jarg2, char jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_reset")]
  public static extern int switch_ivr_digit_stream_reset(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_digit_stream_parser_set_terminator")]
  public static extern int switch_ivr_digit_stream_parser_set_terminator(HandleRef jarg1, char jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_init")]
  public static extern int switch_ivr_menu_init(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4, string jarg5, string jarg6, string jarg7, string jarg8, string jarg9, int jarg10, int jarg11, int jarg12, int jarg13, int jarg14, HandleRef jarg15);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_bind_action")]
  public static extern int switch_ivr_menu_bind_action(HandleRef jarg1, int jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_bind_function")]
  public static extern int switch_ivr_menu_bind_function(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_execute")]
  public static extern int switch_ivr_menu_execute(HandleRef jarg1, HandleRef jarg2, string jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_stack_free")]
  public static extern int switch_ivr_menu_stack_free(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_stack_xml_build")]
  public static extern int switch_ivr_menu_stack_xml_build(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_str2action")]
  public static extern int switch_ivr_menu_str2action(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_stack_xml_add_custom")]
  public static extern int switch_ivr_menu_stack_xml_add_custom(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_menu_stack_xml_init")]
  public static extern int switch_ivr_menu_stack_xml_init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_phrase_macro")]
  public static extern int switch_ivr_phrase_macro(HandleRef jarg1, string jarg2, string jarg3, string jarg4, HandleRef jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_delay_echo")]
  public static extern void switch_ivr_delay_echo(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_find_bridged_uuid")]
  public static extern int switch_ivr_find_bridged_uuid(string jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_intercept_session")]
  public static extern void switch_ivr_intercept_session(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_park_session")]
  public static extern void switch_ivr_park_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_wait_for_answer")]
  public static extern int switch_ivr_wait_for_answer(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_read")]
  public static extern int switch_ivr_read(HandleRef jarg1, uint jarg2, uint jarg3, string jarg4, string jarg5, string jarg6, HandleRef jarg7, uint jarg8, string jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_bind_dtmf_meta_session")]
  public static extern int switch_ivr_bind_dtmf_meta_session(HandleRef jarg1, uint jarg2, int jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_unbind_dtmf_meta_session")]
  public static extern int switch_ivr_unbind_dtmf_meta_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_soft_hold")]
  public static extern int switch_ivr_soft_hold(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_say")]
  public static extern int switch_ivr_say(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_get_say_method_by_name")]
  public static extern int switch_ivr_get_say_method_by_name(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_ivr_get_say_type_by_name")]
  public static extern int switch_ivr_get_say_type_by_name(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RTP_MAX_BUF_LEN_get")]
  public static extern int SWITCH_RTP_MAX_BUF_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RTP_MAX_CRYPTO_LEN_get")]
  public static extern int SWITCH_RTP_MAX_CRYPTO_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RTP_KEY_LEN_get")]
  public static extern int SWITCH_RTP_KEY_LEN_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RTP_CRYPTO_KEY_32_get")]
  public static extern string SWITCH_RTP_CRYPTO_KEY_32_get();

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_RTP_CRYPTO_KEY_80_get")]
  public static extern string SWITCH_RTP_CRYPTO_KEY_80_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_index_set")]
  public static extern void switch_rtp_crypto_key_index_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_index_get")]
  public static extern uint switch_rtp_crypto_key_index_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_type_set")]
  public static extern void switch_rtp_crypto_key_type_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_type_get")]
  public static extern int switch_rtp_crypto_key_type_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_key_set")]
  public static extern void switch_rtp_crypto_key_key_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_key_get")]
  public static extern IntPtr switch_rtp_crypto_key_key_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_keylen_set")]
  public static extern void switch_rtp_crypto_key_keylen_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_keylen_get")]
  public static extern IntPtr switch_rtp_crypto_key_keylen_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_next_set")]
  public static extern void switch_rtp_crypto_key_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_crypto_key_next_get")]
  public static extern IntPtr switch_rtp_crypto_key_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_rtp_crypto_key")]
  public static extern IntPtr new_switch_rtp_crypto_key();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_rtp_crypto_key")]
  public static extern void delete_switch_rtp_crypto_key(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_add_crypto_key")]
  public static extern int switch_rtp_add_crypto_key(HandleRef jarg1, int jarg2, uint jarg3, int jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_get_random")]
  public static extern void switch_rtp_get_random(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_init")]
  public static extern void switch_rtp_init(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_shutdown")]
  public static extern void switch_rtp_shutdown();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_start_port")]
  public static extern ushort switch_rtp_set_start_port(ushort jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_end_port")]
  public static extern ushort switch_rtp_set_end_port(ushort jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_request_port")]
  public static extern ushort switch_rtp_request_port(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_release_port")]
  public static extern void switch_rtp_release_port(string jarg1, ushort jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_create")]
  public static extern int switch_rtp_create(HandleRef jarg1, byte jarg2, uint jarg3, uint jarg4, int jarg5, string jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_new")]
  public static extern IntPtr switch_rtp_new(string jarg1, ushort jarg2, string jarg3, ushort jarg4, byte jarg5, uint jarg6, uint jarg7, int jarg8, string jarg9, HandleRef jarg10, HandleRef jarg11);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_remote_address")]
  public static extern int switch_rtp_set_remote_address(HandleRef jarg1, string jarg2, ushort jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_max_missed_packets")]
  public static extern void switch_rtp_set_max_missed_packets(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_local_address")]
  public static extern int switch_rtp_set_local_address(HandleRef jarg1, string jarg2, ushort jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_kill_socket")]
  public static extern void switch_rtp_kill_socket(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_break")]
  public static extern void switch_rtp_break(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_ready")]
  public static extern byte switch_rtp_ready(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_destroy")]
  public static extern void switch_rtp_destroy(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_activate_ice")]
  public static extern int switch_rtp_activate_ice(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_activate_jitter_buffer")]
  public static extern int switch_rtp_activate_jitter_buffer(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_flag")]
  public static extern void switch_rtp_set_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_test_flag")]
  public static extern uint switch_rtp_test_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_clear_flag")]
  public static extern void switch_rtp_clear_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_get_rtp_socket")]
  public static extern IntPtr switch_rtp_get_rtp_socket(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_default_samples_per_interval")]
  public static extern void switch_rtp_set_default_samples_per_interval(HandleRef jarg1, ushort jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_get_default_samples_per_interval")]
  public static extern uint switch_rtp_get_default_samples_per_interval(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_default_payload")]
  public static extern void switch_rtp_set_default_payload(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_get_default_payload")]
  public static extern uint switch_rtp_get_default_payload(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_invald_handler")]
  public static extern void switch_rtp_set_invald_handler(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_read")]
  public static extern int switch_rtp_read(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_queue_rfc2833")]
  public static extern int switch_rtp_queue_rfc2833(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_queue_rfc2833_in")]
  public static extern int switch_rtp_queue_rfc2833_in(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_has_dtmf")]
  public static extern IntPtr switch_rtp_has_dtmf(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_dequeue_dtmf")]
  public static extern IntPtr switch_rtp_dequeue_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_zerocopy_read")]
  public static extern int switch_rtp_zerocopy_read(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_zerocopy_read_frame")]
  public static extern int switch_rtp_zerocopy_read_frame(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_enable_vad")]
  public static extern int switch_rtp_enable_vad(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_disable_vad")]
  public static extern int switch_rtp_disable_vad(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_write_frame")]
  public static extern int switch_rtp_write_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_write_manual")]
  public static extern int switch_rtp_write_manual(HandleRef jarg1, HandleRef jarg2, uint jarg3, byte jarg4, byte jarg5, uint jarg6, HandleRef jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_get_ssrc")]
  public static extern uint switch_rtp_get_ssrc(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_private")]
  public static extern void switch_rtp_set_private(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_telephony_event")]
  public static extern void switch_rtp_set_telephony_event(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_set_cng_pt")]
  public static extern void switch_rtp_set_cng_pt(HandleRef jarg1, byte jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_rtp_get_private")]
  public static extern IntPtr switch_rtp_get_private(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_data_set")]
  public static extern void switch_log_node_t_data_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_data_get")]
  public static extern string switch_log_node_t_data_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_file_set")]
  public static extern void switch_log_node_t_file_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_file_get")]
  public static extern string switch_log_node_t_file_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_line_set")]
  public static extern void switch_log_node_t_line_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_line_get")]
  public static extern uint switch_log_node_t_line_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_func_set")]
  public static extern void switch_log_node_t_func_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_func_get")]
  public static extern string switch_log_node_t_func_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_level_set")]
  public static extern void switch_log_node_t_level_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_level_get")]
  public static extern int switch_log_node_t_level_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_timestamp_set")]
  public static extern void switch_log_node_t_timestamp_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_timestamp_get")]
  public static extern IntPtr switch_log_node_t_timestamp_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_content_set")]
  public static extern void switch_log_node_t_content_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_content_get")]
  public static extern string switch_log_node_t_content_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_userdata_set")]
  public static extern void switch_log_node_t_userdata_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_node_t_userdata_get")]
  public static extern string switch_log_node_t_userdata_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_log_node_t")]
  public static extern IntPtr new_switch_log_node_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_log_node_t")]
  public static extern void delete_switch_log_node_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_init")]
  public static extern int switch_log_init(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_shutdown")]
  public static extern int switch_log_shutdown();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_bind_logger")]
  public static extern int switch_log_bind_logger(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_level2str")]
  public static extern string switch_log_level2str(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_str2level")]
  public static extern int switch_log_str2level(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_log_str2mask")]
  public static extern uint switch_log_str2mask(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_SWITCH_XML_BUFSIZE_get")]
  public static extern int SWITCH_XML_BUFSIZE_get();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_name_set")]
  public static extern void switch_xml_name_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_name_get")]
  public static extern string switch_xml_name_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_attr_set")]
  public static extern void switch_xml_attr_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_attr_get")]
  public static extern IntPtr switch_xml_attr_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_txt_set")]
  public static extern void switch_xml_txt_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_txt_get")]
  public static extern string switch_xml_txt_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_free_path_set")]
  public static extern void switch_xml_free_path_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_free_path_get")]
  public static extern string switch_xml_free_path_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_off_set")]
  public static extern void switch_xml_off_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_off_get")]
  public static extern IntPtr switch_xml_off_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_next_set")]
  public static extern void switch_xml_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_next_get")]
  public static extern IntPtr switch_xml_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_sibling_set")]
  public static extern void switch_xml_sibling_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_sibling_get")]
  public static extern IntPtr switch_xml_sibling_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_ordered_set")]
  public static extern void switch_xml_ordered_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_ordered_get")]
  public static extern IntPtr switch_xml_ordered_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_child_set")]
  public static extern void switch_xml_child_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_child_get")]
  public static extern IntPtr switch_xml_child_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parent_set")]
  public static extern void switch_xml_parent_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parent_get")]
  public static extern IntPtr switch_xml_parent_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_flags_set")]
  public static extern void switch_xml_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_flags_get")]
  public static extern uint switch_xml_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_xml")]
  public static extern IntPtr new_switch_xml();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_xml")]
  public static extern void delete_switch_xml(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parse_str")]
  public static extern IntPtr switch_xml_parse_str(string jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parse_fd")]
  public static extern IntPtr switch_xml_parse_fd(int jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parse_file")]
  public static extern IntPtr switch_xml_parse_file(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parse_file_simple")]
  public static extern IntPtr switch_xml_parse_file_simple(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parse_fp")]
  public static extern IntPtr switch_xml_parse_fp(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_child")]
  public static extern IntPtr switch_xml_child(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_find_child")]
  public static extern IntPtr switch_xml_find_child(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_attr")]
  public static extern string switch_xml_attr(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_attr_soft")]
  public static extern string switch_xml_attr_soft(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_get")]
  public static extern IntPtr switch_xml_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_toxml")]
  public static extern string switch_xml_toxml(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_toxml_buf")]
  public static extern string switch_xml_toxml_buf(HandleRef jarg1, string jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_pi")]
  public static extern IntPtr switch_xml_pi(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_free")]
  public static extern void switch_xml_free(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_error")]
  public static extern string switch_xml_error(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_new")]
  public static extern IntPtr switch_xml_new(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_add_child")]
  public static extern IntPtr switch_xml_add_child(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_set_txt")]
  public static extern IntPtr switch_xml_set_txt(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_set_attr")]
  public static extern IntPtr switch_xml_set_attr(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_set_flag")]
  public static extern IntPtr switch_xml_set_flag(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_cut")]
  public static extern IntPtr switch_xml_cut(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_insert")]
  public static extern IntPtr switch_xml_insert(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_open_root")]
  public static extern IntPtr switch_xml_open_root(byte jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_init")]
  public static extern int switch_xml_init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_destroy")]
  public static extern int switch_xml_destroy();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_root")]
  public static extern IntPtr switch_xml_root();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_locate")]
  public static extern int switch_xml_locate(string jarg1, string jarg2, string jarg3, string jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_locate_domain")]
  public static extern int switch_xml_locate_domain(string jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_locate_user")]
  public static extern int switch_xml_locate_user(string jarg1, string jarg2, string jarg3, string jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_open_cfg")]
  public static extern IntPtr switch_xml_open_cfg(string jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_bind_search_function")]
  public static extern int switch_xml_bind_search_function(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_xml_parse_section_string")]
  public static extern int switch_xml_parse_section_string(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_outgoing_channel_outgoing_channel_set")]
  public static extern void switch_io_event_hook_outgoing_channel_outgoing_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_outgoing_channel_outgoing_channel_get")]
  public static extern IntPtr switch_io_event_hook_outgoing_channel_outgoing_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_outgoing_channel_next_set")]
  public static extern void switch_io_event_hook_outgoing_channel_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_outgoing_channel_next_get")]
  public static extern IntPtr switch_io_event_hook_outgoing_channel_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_outgoing_channel")]
  public static extern IntPtr new_switch_io_event_hook_outgoing_channel();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_outgoing_channel")]
  public static extern void delete_switch_io_event_hook_outgoing_channel(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_message_receive_message_set")]
  public static extern void switch_io_event_hook_receive_message_receive_message_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_message_receive_message_get")]
  public static extern IntPtr switch_io_event_hook_receive_message_receive_message_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_message_next_set")]
  public static extern void switch_io_event_hook_receive_message_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_message_next_get")]
  public static extern IntPtr switch_io_event_hook_receive_message_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_receive_message")]
  public static extern IntPtr new_switch_io_event_hook_receive_message();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_receive_message")]
  public static extern void delete_switch_io_event_hook_receive_message(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_event_receive_event_set")]
  public static extern void switch_io_event_hook_receive_event_receive_event_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_event_receive_event_get")]
  public static extern IntPtr switch_io_event_hook_receive_event_receive_event_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_event_next_set")]
  public static extern void switch_io_event_hook_receive_event_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_receive_event_next_get")]
  public static extern IntPtr switch_io_event_hook_receive_event_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_receive_event")]
  public static extern IntPtr new_switch_io_event_hook_receive_event();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_receive_event")]
  public static extern void delete_switch_io_event_hook_receive_event(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_read_frame_read_frame_set")]
  public static extern void switch_io_event_hook_read_frame_read_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_read_frame_read_frame_get")]
  public static extern IntPtr switch_io_event_hook_read_frame_read_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_read_frame_next_set")]
  public static extern void switch_io_event_hook_read_frame_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_read_frame_next_get")]
  public static extern IntPtr switch_io_event_hook_read_frame_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_read_frame")]
  public static extern IntPtr new_switch_io_event_hook_read_frame();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_read_frame")]
  public static extern void delete_switch_io_event_hook_read_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_read_frame_video_read_frame_set")]
  public static extern void switch_io_event_hook_video_read_frame_video_read_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_read_frame_video_read_frame_get")]
  public static extern IntPtr switch_io_event_hook_video_read_frame_video_read_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_read_frame_next_set")]
  public static extern void switch_io_event_hook_video_read_frame_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_read_frame_next_get")]
  public static extern IntPtr switch_io_event_hook_video_read_frame_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_video_read_frame")]
  public static extern IntPtr new_switch_io_event_hook_video_read_frame();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_video_read_frame")]
  public static extern void delete_switch_io_event_hook_video_read_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_write_frame_write_frame_set")]
  public static extern void switch_io_event_hook_write_frame_write_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_write_frame_write_frame_get")]
  public static extern IntPtr switch_io_event_hook_write_frame_write_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_write_frame_next_set")]
  public static extern void switch_io_event_hook_write_frame_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_write_frame_next_get")]
  public static extern IntPtr switch_io_event_hook_write_frame_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_write_frame")]
  public static extern IntPtr new_switch_io_event_hook_write_frame();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_write_frame")]
  public static extern void delete_switch_io_event_hook_write_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_write_frame_video_write_frame_set")]
  public static extern void switch_io_event_hook_video_write_frame_video_write_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_write_frame_video_write_frame_get")]
  public static extern IntPtr switch_io_event_hook_video_write_frame_video_write_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_write_frame_next_set")]
  public static extern void switch_io_event_hook_video_write_frame_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_video_write_frame_next_get")]
  public static extern IntPtr switch_io_event_hook_video_write_frame_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_video_write_frame")]
  public static extern IntPtr new_switch_io_event_hook_video_write_frame();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_video_write_frame")]
  public static extern void delete_switch_io_event_hook_video_write_frame(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_kill_channel_kill_channel_set")]
  public static extern void switch_io_event_hook_kill_channel_kill_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_kill_channel_kill_channel_get")]
  public static extern IntPtr switch_io_event_hook_kill_channel_kill_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_kill_channel_next_set")]
  public static extern void switch_io_event_hook_kill_channel_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_kill_channel_next_get")]
  public static extern IntPtr switch_io_event_hook_kill_channel_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_kill_channel")]
  public static extern IntPtr new_switch_io_event_hook_kill_channel();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_kill_channel")]
  public static extern void delete_switch_io_event_hook_kill_channel(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_send_dtmf_send_dtmf_set")]
  public static extern void switch_io_event_hook_send_dtmf_send_dtmf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_send_dtmf_send_dtmf_get")]
  public static extern IntPtr switch_io_event_hook_send_dtmf_send_dtmf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_send_dtmf_next_set")]
  public static extern void switch_io_event_hook_send_dtmf_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_send_dtmf_next_get")]
  public static extern IntPtr switch_io_event_hook_send_dtmf_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_send_dtmf")]
  public static extern IntPtr new_switch_io_event_hook_send_dtmf();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_send_dtmf")]
  public static extern void delete_switch_io_event_hook_send_dtmf(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_recv_dtmf_recv_dtmf_set")]
  public static extern void switch_io_event_hook_recv_dtmf_recv_dtmf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_recv_dtmf_recv_dtmf_get")]
  public static extern IntPtr switch_io_event_hook_recv_dtmf_recv_dtmf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_recv_dtmf_next_set")]
  public static extern void switch_io_event_hook_recv_dtmf_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_recv_dtmf_next_get")]
  public static extern IntPtr switch_io_event_hook_recv_dtmf_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_recv_dtmf")]
  public static extern IntPtr new_switch_io_event_hook_recv_dtmf();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_recv_dtmf")]
  public static extern void delete_switch_io_event_hook_recv_dtmf(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_state_change_state_change_set")]
  public static extern void switch_io_event_hook_state_change_state_change_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_state_change_state_change_get")]
  public static extern IntPtr switch_io_event_hook_state_change_state_change_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_state_change_next_set")]
  public static extern void switch_io_event_hook_state_change_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_state_change_next_get")]
  public static extern IntPtr switch_io_event_hook_state_change_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_state_change")]
  public static extern IntPtr new_switch_io_event_hook_state_change();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_state_change")]
  public static extern void delete_switch_io_event_hook_state_change(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_resurrect_session_resurrect_session_set")]
  public static extern void switch_io_event_hook_resurrect_session_resurrect_session_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_resurrect_session_resurrect_session_get")]
  public static extern IntPtr switch_io_event_hook_resurrect_session_resurrect_session_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_resurrect_session_next_set")]
  public static extern void switch_io_event_hook_resurrect_session_next_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hook_resurrect_session_next_get")]
  public static extern IntPtr switch_io_event_hook_resurrect_session_next_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hook_resurrect_session")]
  public static extern IntPtr new_switch_io_event_hook_resurrect_session();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hook_resurrect_session")]
  public static extern void delete_switch_io_event_hook_resurrect_session(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_outgoing_channel_set")]
  public static extern void switch_io_event_hooks_outgoing_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_outgoing_channel_get")]
  public static extern IntPtr switch_io_event_hooks_outgoing_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_receive_message_set")]
  public static extern void switch_io_event_hooks_receive_message_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_receive_message_get")]
  public static extern IntPtr switch_io_event_hooks_receive_message_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_receive_event_set")]
  public static extern void switch_io_event_hooks_receive_event_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_receive_event_get")]
  public static extern IntPtr switch_io_event_hooks_receive_event_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_read_frame_set")]
  public static extern void switch_io_event_hooks_read_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_read_frame_get")]
  public static extern IntPtr switch_io_event_hooks_read_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_video_read_frame_set")]
  public static extern void switch_io_event_hooks_video_read_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_video_read_frame_get")]
  public static extern IntPtr switch_io_event_hooks_video_read_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_write_frame_set")]
  public static extern void switch_io_event_hooks_write_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_write_frame_get")]
  public static extern IntPtr switch_io_event_hooks_write_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_video_write_frame_set")]
  public static extern void switch_io_event_hooks_video_write_frame_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_video_write_frame_get")]
  public static extern IntPtr switch_io_event_hooks_video_write_frame_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_kill_channel_set")]
  public static extern void switch_io_event_hooks_kill_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_kill_channel_get")]
  public static extern IntPtr switch_io_event_hooks_kill_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_send_dtmf_set")]
  public static extern void switch_io_event_hooks_send_dtmf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_send_dtmf_get")]
  public static extern IntPtr switch_io_event_hooks_send_dtmf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_recv_dtmf_set")]
  public static extern void switch_io_event_hooks_recv_dtmf_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_recv_dtmf_get")]
  public static extern IntPtr switch_io_event_hooks_recv_dtmf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_state_change_set")]
  public static extern void switch_io_event_hooks_state_change_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_state_change_get")]
  public static extern IntPtr switch_io_event_hooks_state_change_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_resurrect_session_set")]
  public static extern void switch_io_event_hooks_resurrect_session_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_io_event_hooks_resurrect_session_get")]
  public static extern IntPtr switch_io_event_hooks_resurrect_session_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_io_event_hooks")]
  public static extern IntPtr new_switch_io_event_hooks();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_io_event_hooks")]
  public static extern void delete_switch_io_event_hooks(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_outgoing_channel")]
  public static extern int switch_core_event_hook_add_outgoing_channel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_receive_message")]
  public static extern int switch_core_event_hook_add_receive_message(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_receive_event")]
  public static extern int switch_core_event_hook_add_receive_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_state_change")]
  public static extern int switch_core_event_hook_add_state_change(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_read_frame")]
  public static extern int switch_core_event_hook_add_read_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_write_frame")]
  public static extern int switch_core_event_hook_add_write_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_video_read_frame")]
  public static extern int switch_core_event_hook_add_video_read_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_video_write_frame")]
  public static extern int switch_core_event_hook_add_video_write_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_kill_channel")]
  public static extern int switch_core_event_hook_add_kill_channel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_send_dtmf")]
  public static extern int switch_core_event_hook_add_send_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_recv_dtmf")]
  public static extern int switch_core_event_hook_add_recv_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_add_resurrect_session")]
  public static extern int switch_core_event_hook_add_resurrect_session(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_outgoing_channel")]
  public static extern int switch_core_event_hook_remove_outgoing_channel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_receive_message")]
  public static extern int switch_core_event_hook_remove_receive_message(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_receive_event")]
  public static extern int switch_core_event_hook_remove_receive_event(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_state_change")]
  public static extern int switch_core_event_hook_remove_state_change(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_read_frame")]
  public static extern int switch_core_event_hook_remove_read_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_write_frame")]
  public static extern int switch_core_event_hook_remove_write_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_video_read_frame")]
  public static extern int switch_core_event_hook_remove_video_read_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_video_write_frame")]
  public static extern int switch_core_event_hook_remove_video_write_frame(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_kill_channel")]
  public static extern int switch_core_event_hook_remove_kill_channel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_send_dtmf")]
  public static extern int switch_core_event_hook_remove_send_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_recv_dtmf")]
  public static extern int switch_core_event_hook_remove_recv_dtmf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_core_event_hook_remove_resurrect_session")]
  public static extern int switch_core_event_hook_remove_resurrect_session(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_created_set")]
  public static extern void switch_scheduler_task_created_set(HandleRef jarg1, long jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_created_get")]
  public static extern long switch_scheduler_task_created_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_runtime_set")]
  public static extern void switch_scheduler_task_runtime_set(HandleRef jarg1, long jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_runtime_get")]
  public static extern long switch_scheduler_task_runtime_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_cmd_id_set")]
  public static extern void switch_scheduler_task_cmd_id_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_cmd_id_get")]
  public static extern uint switch_scheduler_task_cmd_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_group_set")]
  public static extern void switch_scheduler_task_group_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_group_get")]
  public static extern string switch_scheduler_task_group_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_cmd_arg_set")]
  public static extern void switch_scheduler_task_cmd_arg_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_cmd_arg_get")]
  public static extern IntPtr switch_scheduler_task_cmd_arg_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_task_id_set")]
  public static extern void switch_scheduler_task_task_id_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_task_id_get")]
  public static extern uint switch_scheduler_task_task_id_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_scheduler_task")]
  public static extern IntPtr new_switch_scheduler_task();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_scheduler_task")]
  public static extern void delete_switch_scheduler_task(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_add_task")]
  public static extern uint switch_scheduler_add_task(HandleRef jarg1, HandleRef jarg2, string jarg3, string jarg4, uint jarg5, HandleRef jarg6, int jarg7);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_del_task_id")]
  public static extern uint switch_scheduler_del_task_id(uint jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_del_task_group")]
  public static extern uint switch_scheduler_del_task_group(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_thread_start")]
  public static extern void switch_scheduler_task_thread_start();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_scheduler_task_thread_stop")]
  public static extern void switch_scheduler_task_thread_stop();

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_file_set")]
  public static extern void switch_config_file_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_file_get")]
  public static extern IntPtr switch_config_file_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_path_set")]
  public static extern void switch_config_path_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_path_get")]
  public static extern string switch_config_path_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_category_set")]
  public static extern void switch_config_category_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_category_get")]
  public static extern string switch_config_category_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_section_set")]
  public static extern void switch_config_section_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_section_get")]
  public static extern string switch_config_section_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_buf_set")]
  public static extern void switch_config_buf_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_buf_get")]
  public static extern string switch_config_buf_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_lineno_set")]
  public static extern void switch_config_lineno_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_lineno_get")]
  public static extern int switch_config_lineno_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_catno_set")]
  public static extern void switch_config_catno_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_catno_get")]
  public static extern int switch_config_catno_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_sectno_set")]
  public static extern void switch_config_sectno_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_sectno_get")]
  public static extern int switch_config_sectno_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_lockto_set")]
  public static extern void switch_config_lockto_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_lockto_get")]
  public static extern int switch_config_lockto_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_switch_config")]
  public static extern IntPtr new_switch_config();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_switch_config")]
  public static extern void delete_switch_config(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_open_file")]
  public static extern int switch_config_open_file(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_close_file")]
  public static extern void switch_config_close_file(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_switch_config_next_pair")]
  public static extern int switch_config_next_pair(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_consoleLog")]
  public static extern void consoleLog(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_consoleCleanLog")]
  public static extern void consoleCleanLog(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_IvrMenu")]
  public static extern IntPtr new_IvrMenu(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5, string jarg6, string jarg7, string jarg8, int jarg9, int jarg10, int jarg11, int jarg12, int jarg13);

  [DllImport("mod_mono", EntryPoint="CSharp_delete_IvrMenu")]
  public static extern void delete_IvrMenu(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_IvrMenu_bindAction")]
  public static extern void IvrMenu_bindAction(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_IvrMenu_Execute")]
  public static extern void IvrMenu_Execute(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_new_Api")]
  public static extern IntPtr new_Api();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_Api")]
  public static extern void delete_Api(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Api_Execute")]
  public static extern string Api_Execute(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_Api_ExecuteString")]
  public static extern string Api_ExecuteString(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_function_set")]
  public static extern void input_callback_state_t_function_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_function_get")]
  public static extern IntPtr input_callback_state_t_function_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_threadState_set")]
  public static extern void input_callback_state_t_threadState_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_threadState_get")]
  public static extern IntPtr input_callback_state_t_threadState_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_extra_set")]
  public static extern void input_callback_state_t_extra_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_extra_get")]
  public static extern IntPtr input_callback_state_t_extra_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_funcargs_set")]
  public static extern void input_callback_state_t_funcargs_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_input_callback_state_t_funcargs_get")]
  public static extern string input_callback_state_t_funcargs_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_input_callback_state_t")]
  public static extern IntPtr new_input_callback_state_t();

  [DllImport("mod_mono", EntryPoint="CSharp_delete_input_callback_state_t")]
  public static extern void delete_input_callback_state_t(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_Stream__SWIG_0")]
  public static extern IntPtr new_Stream__SWIG_0();

  [DllImport("mod_mono", EntryPoint="CSharp_new_Stream__SWIG_1")]
  public static extern IntPtr new_Stream__SWIG_1(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_delete_Stream")]
  public static extern void delete_Stream(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Stream_Write")]
  public static extern void Stream_Write(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Stream_get_data")]
  public static extern string Stream_get_data(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_InternalEvent_set")]
  public static extern void Event_InternalEvent_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_InternalEvent_get")]
  public static extern IntPtr Event_InternalEvent_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_serialized_string_set")]
  public static extern void Event_serialized_string_set(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_serialized_string_get")]
  public static extern string Event_serialized_string_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_mine_set")]
  public static extern void Event_mine_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_mine_get")]
  public static extern int Event_mine_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_Event__SWIG_0")]
  public static extern IntPtr new_Event__SWIG_0(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_new_Event__SWIG_1")]
  public static extern IntPtr new_Event__SWIG_1(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_delete_Event")]
  public static extern void delete_Event(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_Serialize")]
  public static extern string Event_Serialize(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_SetPriority")]
  public static extern bool Event_SetPriority(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_GetHeader")]
  public static extern string Event_GetHeader(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_GetBody")]
  public static extern string Event_GetBody(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_GetEventType")]
  public static extern string Event_GetEventType(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_AddBody")]
  public static extern bool Event_AddBody(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_AddHeader")]
  public static extern bool Event_AddHeader(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_DeleteHeader")]
  public static extern bool Event_DeleteHeader(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_Event_Fire")]
  public static extern bool Event_Fire(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_delete_CoreSession")]
  public static extern void delete_CoreSession(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_InternalSession_set")]
  public static extern void CoreSession_InternalSession_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_InternalSession_get")]
  public static extern IntPtr CoreSession_InternalSession_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_channel_set")]
  public static extern void CoreSession_channel_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_channel_get")]
  public static extern IntPtr CoreSession_channel_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_flags_set")]
  public static extern void CoreSession_flags_set(HandleRef jarg1, uint jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_flags_get")]
  public static extern uint CoreSession_flags_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_allocated_set")]
  public static extern void CoreSession_allocated_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_allocated_get")]
  public static extern int CoreSession_allocated_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_cb_state_set")]
  public static extern void CoreSession_cb_state_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_cb_state_get")]
  public static extern IntPtr CoreSession_cb_state_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_HookState_set")]
  public static extern void CoreSession_HookState_set(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_HookState_get")]
  public static extern int CoreSession_HookState_get(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Answer")]
  public static extern int CoreSession_Answer(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_preAnswer")]
  public static extern int CoreSession_preAnswer(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Hangup")]
  public static extern void CoreSession_Hangup(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_SetVariable")]
  public static extern void CoreSession_SetVariable(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_SetPrivate")]
  public static extern void CoreSession_SetPrivate(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_GetPrivate")]
  public static extern IntPtr CoreSession_GetPrivate(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_GetVariable")]
  public static extern string CoreSession_GetVariable(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Say")]
  public static extern void CoreSession_Say(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_SayPhrase")]
  public static extern void CoreSession_SayPhrase(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_RecordFile")]
  public static extern int CoreSession_RecordFile(HandleRef jarg1, string jarg2, int jarg3, int jarg4, int jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_SetCallerData")]
  public static extern void CoreSession_SetCallerData(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Originate")]
  public static extern int CoreSession_Originate(HandleRef jarg1, HandleRef jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_speak")]
  public static extern int CoreSession_speak(HandleRef jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_set_tts_parms")]
  public static extern void CoreSession_set_tts_parms(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_CollectDigits")]
  public static extern int CoreSession_CollectDigits(HandleRef jarg1, int jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_GetDigits")]
  public static extern string CoreSession_GetDigits(HandleRef jarg1, int jarg2, string jarg3, int jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Transfer")]
  public static extern int CoreSession_Transfer(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_read")]
  public static extern string CoreSession_read(HandleRef jarg1, int jarg2, int jarg3, string jarg4, int jarg5, string jarg6);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_PlayAndGetDigits")]
  public static extern string CoreSession_PlayAndGetDigits(HandleRef jarg1, int jarg2, int jarg3, int jarg4, int jarg5, string jarg6, string jarg7, string jarg8, string jarg9);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_StreamFile")]
  public static extern int CoreSession_StreamFile(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_flushEvents")]
  public static extern int CoreSession_flushEvents(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_flushDigits")]
  public static extern int CoreSession_flushDigits(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_setAutoHangup")]
  public static extern int CoreSession_setAutoHangup(HandleRef jarg1, bool jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Ready")]
  public static extern bool CoreSession_Ready(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_Execute")]
  public static extern void CoreSession_Execute(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_sendEvent")]
  public static extern void CoreSession_sendEvent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_setEventData")]
  public static extern void CoreSession_setEventData(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_getXMLCDR")]
  public static extern string CoreSession_getXMLCDR(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_begin_allow_threads")]
  public static extern bool CoreSession_begin_allow_threads(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_end_allow_threads")]
  public static extern bool CoreSession_end_allow_threads(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_GetUuid")]
  public static extern string CoreSession_GetUuid(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_get_cb_args")]
  public static extern IntPtr CoreSession_get_cb_args(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_CoreSession_check_hangup_hook")]
  public static extern void CoreSession_check_hangup_hook(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_console_log")]
  public static extern void console_log(string jarg1, string jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_console_clean_log")]
  public static extern void console_clean_log(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_bridge")]
  public static extern void bridge(HandleRef jarg1, HandleRef jarg2);

  [DllImport("mod_mono", EntryPoint="CSharp_hanguphook")]
  public static extern int hanguphook(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_dtmf_callback")]
  public static extern int dtmf_callback(HandleRef jarg1, HandleRef jarg2, int jarg3, HandleRef jarg4, uint jarg5);

  [DllImport("mod_mono", EntryPoint="CSharp_new_MonoSession__SWIG_0")]
  public static extern IntPtr new_MonoSession__SWIG_0();

  [DllImport("mod_mono", EntryPoint="CSharp_new_MonoSession__SWIG_1")]
  public static extern IntPtr new_MonoSession__SWIG_1(string jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_new_MonoSession__SWIG_2")]
  public static extern IntPtr new_MonoSession__SWIG_2(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_delete_MonoSession")]
  public static extern void delete_MonoSession(HandleRef jarg1);

  [DllImport("mod_mono", EntryPoint="CSharp_MonoSessionUpcast")]
  public static extern IntPtr MonoSessionUpcast(IntPtr objectRef);
}

}
