/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "rtsp_message.h"
#include "apt_log.h"

apt_bool_t parse_generate_test(apt_text_stream_t *parse_stream, apt_text_stream_t *generate_stream, apr_pool_t *pool)
{
	rtsp_message_t rtsp_message;
	apt_log(APT_PRIO_INFO,"1) Parse and Generate\n");

	apt_log(APT_PRIO_INFO,"-->PARSE\n");
	apt_log(APT_PRIO_INFO,parse_stream->buffer);
	rtsp_message_init(&rtsp_message,RTSP_MESSAGE_TYPE_UNKNOWN,pool);
	if(rtsp_message_parse(&rtsp_message,parse_stream) == FALSE) {
		apt_log(APT_PRIO_WARNING,"failed to parse message\n");
		return FALSE;
	}

	if(rtsp_message_generate(&rtsp_message,generate_stream) == FALSE) {
		apt_log(APT_PRIO_WARNING,"failed to generate message\n");
		return FALSE;
	}
	*generate_stream->pos = '\0';
	rtsp_message_destroy(&rtsp_message);
	apt_log(APT_PRIO_INFO,"\n-->GENERATE\n");
	apt_log(APT_PRIO_INFO,generate_stream->buffer);

	return TRUE;
}


#define TEST_BUFFER_SIZE 2048

int main(int argc, char *argv[])
{
	char parse_buffer[TEST_BUFFER_SIZE];
	char generate_buffer[TEST_BUFFER_SIZE];
	apt_text_stream_t parse_stream;
	apt_text_stream_t generate_stream;
	apr_pool_t *pool;
	FILE *f;
	if(argc < 2) {
		printf("usage: %s rtsp.msg\n", argv[0]);
		return 0;
	}
	f = fopen(argv[1], "rb");
	if(f == NULL) {
		printf("cannot open file %s\n", argv[1]);
		return 0;
	}

	if(apr_initialize() != APR_SUCCESS) {
		apr_terminate();
		return 0;
	}

	if(apr_pool_create(&pool,NULL) != APR_SUCCESS) {
		apr_terminate();
		return 0;
	}

	apt_log_initialize(APT_PRIO_DEBUG);

	parse_stream.size = fread(parse_buffer, 1, sizeof(parse_buffer)-1, f);
	parse_buffer[parse_stream.size] = '\0';
	parse_stream.buffer = parse_buffer;
	parse_stream.pos = parse_buffer;

	generate_stream.buffer = generate_buffer;
	generate_stream.pos = generate_buffer;
	generate_stream.size = TEST_BUFFER_SIZE;

	parse_generate_test(&parse_stream,&generate_stream,pool);

	fclose(f);
	apr_pool_destroy(pool);
	apr_terminate();
	return 0;
}
