/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "apt_string_table.h"
#include "mrcp_media_audio.h"

/* string table of mrcp audio attributes (mrcp_audio_attrib_id) */
static const apt_string_table_item_t mrcp_audio_attrib_table[] = {
	{"rtpmap",   6,1},
	{"sendonly", 8,8},
	{"recvonly", 8,2},
	{"sendrecv", 8,4},
	{"mid",      3,0},
	{"ptime",    5,0}
};


const char* mrcp_audio_attrib_str_get(mrcp_audio_attrib_id attrib_id)
{
	return apt_string_table_get(mrcp_audio_attrib_table,MRCP_AUDIO_ATTRIB_COUNT,attrib_id);
}

mrcp_audio_attrib_id mrcp_audio_attrib_id_find(const char *attrib)
{
	return apt_string_table_find(mrcp_audio_attrib_table,MRCP_AUDIO_ATTRIB_COUNT,attrib);
}

const char* mrcp_audio_direction_str_get(mrcp_audio_direction_t direction)
{
	mrcp_audio_attrib_id attrib_id = MRCP_AUDIO_ATTRIB_UNKNOWN;
	switch(direction) {
		case MRCP_AUDIO_SEND:
			attrib_id = MRCP_AUDIO_ATTRIB_SENDONLY;
			break;
		case MRCP_AUDIO_RECEIVE:
			attrib_id = MRCP_AUDIO_ATTRIB_RECVONLY;
			break;
		case MRCP_AUDIO_DUPLEX:
			attrib_id = MRCP_AUDIO_ATTRIB_SENDRECV;
			break;
		default:
			break;
	}
	return apt_string_table_get(mrcp_audio_attrib_table,MRCP_AUDIO_ATTRIB_COUNT,attrib_id);
}
