/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_DESCRIPTION_H__
#define __MRCP_DESCRIPTION_H__

/**
 * @file mrcp_description.h
 * @brief MRCP Media Description (SDP)
 */ 

#include "mrcp_media_control.h"
#include "mrcp_media_audio.h"

MRCP_BEGIN_EXTERN_C

/** MRCP media types */
typedef enum {
	MRCP_MEDIA_TYPE_CONTROL,
	MRCP_MEDIA_TYPE_AUDIO
} mrcp_media_type;


#define MRCP_MAX_CONTROL_MEDIA_COUNT 5
#define MRCP_MAX_AUDIO_MEDIA_COUNT   5

#define MRCP_MAX_MEDIA_COUNT (MRCP_MAX_CONTROL_MEDIA_COUNT + MRCP_MAX_AUDIO_MEDIA_COUNT)

typedef struct mrcp_descriptor_t mrcp_descriptor_t;
/** MRCP media descriptor */
struct mrcp_descriptor_t {
	const char        *ip;
	mrcp_media_base_t *media[MRCP_MAX_MEDIA_COUNT];
	size_t             media_count;
};

/** Initialize MRCP descriptor */
void mrcp_descriptor_init(mrcp_descriptor_t *descriptor);

/** Create MRCP audio media */
mrcp_media_audio_t* mrcp_audio_media_create(apr_pool_t *pool);

/** Create MRCP control (resource) media */
mrcp_media_control_t* mrcp_control_media_create(apr_pool_t *pool);

/** Add MRCP media to MRCP media descriptor */
mrcp_status_t mrcp_descriptor_media_add(mrcp_descriptor_t *descriptor, mrcp_media_base_t *media);

/** Get MRCP control media by MRCP resource name */
mrcp_media_control_t* mrcp_control_media_get(mrcp_descriptor_t *descriptor, const char *resource_name);

/** Get the first enabled MRCP control media */
mrcp_media_control_t* mrcp_enabled_control_media_get(mrcp_descriptor_t *descriptor);

/** Get MRCP audio media by mid */
mrcp_media_audio_t* mrcp_audio_media_get(mrcp_descriptor_t *descriptor, size_t mid);

/** Get MRCP audio media matched to requested audio direction */
mrcp_media_audio_t* mrcp_audio_media_get_by_direction(mrcp_descriptor_t *descriptor, mrcp_audio_direction_t direction);


MRCP_END_EXTERN_C

#endif /*__MRCP_DESCRIPTION_H__*/
