/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "mrcp_client_session.h"
#include "mrcp_client_resource.h"
#include "mrcp_client_defs.h"
#include "mrcp_signaling_channel.h"

/** Create MRCP Client Session */
mrcp_session_t* mrcp_client_session_create()
{
	size_t i;
	apr_pool_t *session_pool;
	mrcp_session_t* session;

	if(apr_pool_create(&session_pool,NULL) != APR_SUCCESS) {
		return NULL;
	}

	session	= apr_palloc(session_pool,sizeof(mrcp_session_t));
	session->pool = session_pool;

	session->audio_media_count = 0;
	for(i=0; i<MRCP_MAX_MEDIA_COUNT; i++) {
		session->channels[i] = NULL;
	}
	session->id.length = 0;
	session->id.hex_str = NULL;

	session->last_request_id = 0;

	session->handle = NULL;
	session->signaling_channel = NULL;
	session->connection = NULL;
	session->terminating = FALSE;
	return session;
}

/** Destroy MRCP Client Session */
mrcp_status_t mrcp_client_session_destroy(mrcp_session_t *session)
{
	if(session->signaling_channel) {
		session->signaling_channel->method_set->destroy(session->signaling_channel);
		session->signaling_channel = NULL;
	}
	if(session->pool) {
		apr_pool_destroy(session->pool);
		session->pool = NULL;
	}
	return MRCP_STATUS_SUCCESS;
}

/** Create MRCP Client Channel */
mrcp_client_channel_t* mrcp_client_channel_create(mrcp_session_t *session, mrcp_resource_t *resource, 
												  audio_source_t *source, audio_sink_t *sink)
{
	mrcp_client_channel_t *channel = apr_palloc(session->pool,sizeof(mrcp_client_channel_t));
	channel->state = CHANNEL_STATE_NONE;
	channel->resource = resource;
	channel->audio_channel = NULL;
	channel->audio_source = source;
	channel->audio_sink = sink;
	return channel;
}

/** Set Channel to MRCP Client Session */
mrcp_status_t mrcp_client_session_channel_set(mrcp_session_t *session, void *channel, size_t index)
{
	if(index >= MRCP_MAX_MEDIA_COUNT) {
		return MRCP_STATUS_FAILURE;
	}
	session->channels[index] = channel;
	return MRCP_STATUS_SUCCESS;
}

/** Get Channel from MRCP Client Session */
void* mrcp_client_session_channel_get(mrcp_session_t *session, size_t index)
{
	if(index >= MRCP_MAX_MEDIA_COUNT) {
		return NULL;
	}
	return session->channels[index];
}
