/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_CLIENT_SESSION_H__
#define __MRCP_CLIENT_SESSION_H__

/**
 * @file mrcp_client_session.h
 * @brief MRCP Client Session Definition.
 */ 

#include <apr_pools.h>
#include "mrcp_client_types.h"
#include "mrcp_description.h"
#include "media_types.h"

MRCP_BEGIN_EXTERN_C

/** MRCP session */
struct mrcp_session_t {
	/** Unique session identifier */
	mrcp_session_id          id;

	/** Number of channels and actual type of channels (control,audio,...) 
	 *  should be referenced by signaling_channel->local_descriptor 
	 */
	void                    *channels[MRCP_MAX_MEDIA_COUNT];
	/** Used for mid generation */
	size_t                   audio_media_count;
	
	/** Used for request id generation */
	mrcp_request_id          last_request_id;

	/** External handle */
	void                     *handle;
	/** Signaling channel */
	mrcp_signaling_channel_t *signaling_channel;
	/** MRCP connection */
	mrcp_connection_t        *connection;

	/** Indicates in progress session termination */
	apt_bool_t                terminating;
	
	/** Memory pool to allocate memory from */
	apr_pool_t               *pool;
};


/** Create MRCP Client Session */
mrcp_session_t* mrcp_client_session_create();

/** Destroy MRCP Client Session */
mrcp_status_t mrcp_client_session_destroy(mrcp_session_t *session);

/** Create MRCP Client Channel */
mrcp_client_channel_t* mrcp_client_channel_create(mrcp_session_t *session, mrcp_resource_t *resource,
												  audio_source_t *source, audio_sink_t *sink);

/** Set Channel to MRCP Client Session */
mrcp_status_t mrcp_client_session_channel_set(mrcp_session_t *session, void *channel, size_t index);

/** Get Channel from MRCP Client Session */
void* mrcp_client_session_channel_get(mrcp_session_t *session, size_t index);

MRCP_END_EXTERN_C

#endif /*__MRCP_CLIENT_SESSION_H__*/
