/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_CLIENT_DEFS_H__
#define __MRCP_CLIENT_DEFS_H__

/**
 * @file mrcp_client_defs.h
 * @brief MRCP Client Internal Definitions.
 */ 

#include <apr_hash.h>
#include <apr_thread_proc.h>
#include <apr_thread_cond.h>
#include "mrcp_client_types.h"
#include "mrcp_client_resource.h"
#include "mrcp_client_signaling_agent.h"
#include "mrcp_client_proto_agent.h"
#include "mrcp_media_agent.h"
#include "mrcp_engine.h"
#include "apt_task_msg.h"

MRCP_BEGIN_EXTERN_C

/** MRCP client context */
struct mrcp_client_context_t {
	mrcp_module_t                module;

	apt_task_msg_pool_t         *msg_pool;

	void                        *object;
	mrcp_client_event_handler_t *event_handler;
};


/** MRCP client */
struct mrcp_client_t {
	/** Base engine */
	mrcp_engine_t                engine;

	/** Client context */
	mrcp_client_context_t       *client_context;

	/** Module loader of MRCP client */
	mrcp_client_module_loader_t *module_loader;

	/** Container of MRCP client resources */
	mrcp_resource_container_t   *resource_container;

	/** Signaling agent registered to mrcp client */
	mrcp_signaling_agent_t      *signaling_agent;
	/** MRCP protocol agent registered to mrcp client */
	mrcp_proto_agent_t          *proto_agent;
	/** MRCP media agent registered to mrcp client */
	mrcp_media_agent_t          *media_agent;

	/** Memory pool */
	apr_pool_t                  *pool;
	/** Table of mrcp sessions */
	apr_hash_t                  *session_table;

	apr_thread_cond_t           *sync_object;
	apr_thread_mutex_t          *sync_object_mutex;
};


/** Client context message identifiers */
typedef enum {
	MRCP_CLIENT_SESSION_DESTROY,
	MRCP_CLIENT_SESSION_INITIATE,
	MRCP_CLIENT_SESSION_TERMINATE,
	MRCP_CLIENT_CHANNEL_ADD,
	MRCP_CLIENT_CHANNEL_REMOVE,
	MRCP_CLIENT_CHANNEL_MODIFY,
	MRCP_CLIENT_RESOURCE_DISCOVER
} mrcp_client_context_msg_id;

typedef struct mrcp_client_context_msg_t mrcp_client_context_msg_t;

/** Client context message */
struct mrcp_client_context_msg_t {
	mrcp_client_context_msg_id msg_id;
	mrcp_session_t            *session;
	mrcp_client_channel_t     *control_channel;
	mrcp_audio_channel_t      *audio_channel;
	mrcp_message_t            *mrcp_message;
};


MRCP_END_EXTERN_C

#endif /*__MRCP_CLIENT_DEFS_H__*/
