/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __RTP_SESSION_H__
#define __RTP_SESSION_H__

/**
 * @file rtp_session.h
 * @brief RTP Session Definitions
 */ 

#include <apr_network_io.h>
#include "codec_manipulator.h"
#include "media_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Create RTP session */
rtp_session_t* rtp_session_create(const char *local_ip, apr_port_t local_port, apr_pool_t *pool);

/** Destroy RTP session */
apr_status_t rtp_session_destroy(rtp_session_t *rtp_session);

/** Create RTP transmit stream */
audio_sink_t* rtp_session_tx_stream_create(rtp_session_t *rtp_session, const char *remote_ip, apr_port_t remote_port, codec_descriptor_t *codec, const codec_manipulator_t *codec_manipulator, apr_uint16_t ptime);

/** Destroy RTP transmit stream */
apr_status_t rtp_session_tx_stream_destroy(rtp_session_t *rtp_session);

/** Create RTP receive stream */
audio_source_t* rtp_session_rx_stream_create(rtp_session_t *rtp_session, const char *remote_ip, apr_port_t remote_port, codec_descriptor_t *codec, const codec_manipulator_t *codec_manipulator);

/** Destroy RTP receive stream */
apr_status_t rtp_session_rx_stream_destroy(rtp_session_t *rtp_session);

/** Get audio sink by RTP session */
audio_sink_t* rtp_session_audio_sink_get(rtp_session_t *rtp_session);

/** Get audio source by RTP session */
audio_source_t* rtp_session_audio_source_get(rtp_session_t *rtp_session);


#ifdef __cplusplus
}
#endif

#endif /*__RTP_SESSION_H__*/
